# coding: UTF-8

from com.huawei.ism.exception import IsmException
import os.path
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkVBSConfig"

PRE_RES_PATH = py_java_env.get("preResPath")
RES_FILE_NAME = "smartKitPreInspectCheck.sh.rst"
PRE_COLLECT = "smartKitPreInspectCheck"
NULL_STR = "is error"

VBS_START_FLAG = "node_item=vbs_start"
VBS_END_FLAG = "node_item=vbs_end"

FSM_START_FLAG = "node_item=fsm_start"
FSM_END_FLAG = "node_item=fsm_end"


def execute(rest):
    """
    检查FSM和VBS配置文件
    :param env:
    :return:
    """
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    fsm_ip = []
    vbs_ip = []
    get_node_ip(dev_node, fsm_ip, vbs_ip)
    fsm_ret = ""
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)

        fsm_node = ""
        for ip in fsm_ip:
            res_file_is_exit = os.path.exists(PRE_RES_PATH + PRE_COLLECT + os.sep + ip.replace(":", "_") + os.sep + RES_FILE_NAME)
            if res_file_is_exit is True:
                fsm_node = ip
                break

        if len(fsm_node) == 0:
            return (
                    common.INSPECT_UNNORMAL,
                    common.get_err_msg(LANG, "vbs.check.config.fsm.error"),
                    common.get_err_msg(LANG, "vbs.check.config.fsm.error"),
                )

        fsm_node_conf = get_fsm_conf_item(fsm_node)
        LOGGER.logInfo(str(fsm_node_conf))
        if len(fsm_node_conf) == 0:
            return (
                    common.INSPECT_UNNORMAL,
                    common.get_err_msg(LANG, "vbs.check.config.fsm.error"),
                    common.get_err_msg(LANG, "vbs.check.config.fsm.error"),
                )

        LOGGER.logInfo("fsm:" + fsm_node + "   selected node:" + str(vbs_ip))
        progressMap[ITEM_ID] = 30
        observer.updateProgress(progressMap)

        msg_list = dict()
        has_err_node = handle_item_compare(fsm_node_conf, vbs_ip, msg_list)

        progressMap[ITEM_ID] = 80
        observer.updateProgress(progressMap)

        if has_err_node is True:
            err_msg = get_err_conf_msg(msg_list)
            return common.INSPECT_UNNORMAL, err_msg, common.get_err_msg(LANG,
                                                                        "vbs.check.config.error", ",".join(msg_list.keys()))
        return common.INSPECT_PASS, common.get_err_msg(LANG, "vbs.check.config.pass"), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            fsm_ret,
            common.get_err_msg(LANG, "vbs.check.config.handle.error")
        )


def handle_item_compare(fsm_node_conf, vbs_ip, msg_list):
    has_err_node = False
    for ip in vbs_ip:
        has_err_cur_node = False
        vbs_node_conf = get_conf_items(ip)
        LOGGER.logInfo("vbs:" + ip + " item:" + str(vbs_node_conf))
        if len(vbs_node_conf) == 0:
            continue
        err_item_list = dict()
        for fsm_item, fsm_value in fsm_node_conf.items():
            if fsm_item not in vbs_node_conf:
                err_item_list[fsm_item] = NULL_STR
                has_err_node = True
                has_err_cur_node = True
                continue
            vbs_value = vbs_node_conf[fsm_item]
            if fsm_value != vbs_value:
                err_item_list[fsm_item] = vbs_value
                has_err_node = True
                has_err_cur_node = True
        if has_err_cur_node is True:
            msg_list[ip] = err_item_list
    return has_err_node


def get_node_ip(dev_node, fsm_ip, vbs_ip):
    node_list = dev_node.getClusterNodes()
    for node in node_list:
        roles = node.getRoles()
        for role in roles:
            if role == "management":
                manage_ip = node.getManagementIp()
                fsm_ip.append(manage_ip)
        if node.isSelected() is True:
            manage_ip = node.getManagementIp()
            vbs_ip.append(manage_ip)


def get_fsm_ret_msg(fsm_node_conf):
    fsm_msg = "FSM Configuration Items:\n"
    for fsm_item, fsm_value in fsm_node_conf.items():
        fsm_msg = fsm_msg + fsm_item + "=" + fsm_value + "\n"
    return fsm_msg


def get_err_conf_msg(msg_list):
    err_msg_str = ""
    LOGGER.logInfo(msg_list)
    for vbs_ip, vbs_node_err_conf in msg_list.items():
        tmp_items = ""
        for conf_item, conf_item_value in vbs_node_err_conf.items():
            if conf_item_value == NULL_STR:
                tmp_items = "%s\t%s %s\n" % (tmp_items, conf_item, NULL_STR)
            else:
                tmp_items = "%s\t%s=%s\n" % (tmp_items, conf_item, conf_item_value)
        if len(tmp_items) > 0:
            err_msg_str = err_msg_str + common.get_err_msg(LANG, "vbs.check.config.item", (vbs_ip, tmp_items)) + "\n"
    return err_msg_str


def get_fsm_conf_item(ip):
    conf_item = dict()
    cover_ipv6_ip = ip.replace(":", "_")
    res_file_is_exit = os.path.exists(PRE_RES_PATH + PRE_COLLECT + os.sep + cover_ipv6_ip + os.sep + RES_FILE_NAME)
    if res_file_is_exit is False:
        return conf_item
    with open(PRE_RES_PATH + PRE_COLLECT + os.sep + cover_ipv6_ip + os.sep + RES_FILE_NAME, 'r') as f:
        flag = False
        for line in f.readlines():
            line = line.replace("\n", "")
            line = line.strip()
            if flag is False and line != FSM_START_FLAG:
                continue
            if flag is False and line == FSM_START_FLAG:
                flag = True
                continue
            if flag is True and line == FSM_END_FLAG:
                break
            tmp = line.split("=")
            if len(tmp) != 2:
                LOGGER.logInfo("handle error line :" + line + " in " + ip)
                continue
            conf_item[tmp[0]] = tmp[1]
    return conf_item


def get_conf_items(ip):
    conf_item = dict()
    cover_ipv6_ip = ip.replace(":", "_")
    res_file_is_exit = os.path.exists(PRE_RES_PATH + PRE_COLLECT + os.sep + cover_ipv6_ip + os.sep + RES_FILE_NAME)
    if res_file_is_exit is False:
        return conf_item
    with open(PRE_RES_PATH + PRE_COLLECT + os.sep + cover_ipv6_ip + os.sep + RES_FILE_NAME, 'r') as f:
        flag = False
        for line in f.readlines():
            line = line.replace("\n", "")
            line = line.strip()
            if flag is False and line != VBS_START_FLAG:
                continue
            if flag is False and line == VBS_START_FLAG:
                flag = True
                continue
            if flag is True and line == VBS_END_FLAG:
                break
            tmp = line.split("=")
            if len(tmp) != 2:
                LOGGER.logInfo("handle error line :" + line + " in " + ip)
                continue
            conf_item[tmp[0]] = tmp[1]
    return conf_item
