# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_1822_roce_driver_version_801"


def execute(rest):
    """
    检查1822网卡驱动版本
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("check_1822_roce_driver_version_801 begin ...")
        source_info = py_java_env.get("sourceInfo")
        if is_check_pass(source_info):
            return common.INSPECT_PASS, source_info, ""
        dev_version = py_java_env.get("version")
        if is_involve_product_version(dev_version):
            err_code = "check_1822_roce_driver_version.result.not.pass"
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, err_code)
        return common.INSPECT_PASS, source_info, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG,
                                                                      "check_1822_roce_driver_version.result.not.pass")


def is_check_pass(source_info):
    if "FAIL" in source_info:
        return False
    return True


def is_involve_product_version(product_version):
    """
    检查版本信息：目标版本非810、811版本时巡检通过
    """
    version = product_version.replace('.', "")
    if "810" in version or "811" in version:
        return True
    return False
