# coding: UTF-8

import time
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_call_home_ca_cert_expire"


def execute(rest):
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        device_esn = dev_node.getDeviceSerialNumber()
        cmd_str = "{}/deviceManager/rest/{}/certificate".format(base_uri, device_esn)
        ret_list.append(cmd_str)
        rsp_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(rsp_json))
        if not rsp_json.get("data"):
            return (
                common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")
            )

        cmd_str = "{}/deviceManager/rest/{}/system_utc_time".format(base_uri, device_esn)
        ret_list.append(cmd_str)
        time_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(time_json))
        if not time_json.get("data"):
            return (
                common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")
            )
        cur_timestamp = int(time_json.get("data").get("CMO_SYS_UTC_TIME"))

        certificates_info = rsp_json.get("data", [])
        for record in certificates_info:
            if record.get("CERTIFICATE_TYPE") != "8":
                continue

            #获取CA证书过期时间
            expire_time = record.get("CA_CERTIFICATE_EXPIRE_TIME")
            ret_list.append("Call Home CA certificate expiration date: " + expire_time)
            #转换成时间数组
            expire_time_array = time.strptime(expire_time, "%Y-%m-%d")
            #时间数组转换成时间戳
            expire_timestamp = int(time.mktime(expire_time_array))
            ret_list.append("Call Home CA certificate expiration timestamp: " + str(expire_timestamp))

            #获取当前时间戳
            ret_list.append("Current timestamp: " + str(cur_timestamp))

            #检查距离过期是否超过90天
            time_till_expire = expire_timestamp - cur_timestamp
            if time_till_expire < (90 * 24 * 60 * 60):
                return (
                    common.INSPECT_UNNORMAL, "\n".join(ret_list),
                    common.get_err_msg(LANG, "call.home.ca.cert.expire.time.no.pass")
                )
            break
        return common.INSPECT_PASS, "\n".join(ret_list), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")
        )
