# coding: UTF-8

import time
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_cert_expire"

CERT_TRPE = "Cert Type"
EXPIRE_TIME = "Expire Time"
CERT_ISSUSER = "Cert Issuer"
CERT_SUBJECT = "Cert Subject"
USE_OF_CERTIFICATE = "Use"
CA_EXPIRE_TIME = "CA Expire Time"
CA_CERT_ISSUSER = "CA Cert Issuer"
CA_CERT_SUBJECT = "CA Cert Subject"
TYPE_TO_CERT_NAME = {
    "2":["Domain authentication security certificate", u"域认证的安全证书"],
    "3":["HyperMetro arbitration security certificate", u"双活仲裁的安全证书"],
    "5":["FTPS security certificate", u"FTPS的安全证书"],
    "6":["Syslog security certificate", u"Syslog的安全证书"],
    "7":["NTP security certificate", u"NTP的安全证书"],
    "8":["Call Home security certificate", u"Call Home的安全证书"],
    "14":["DeviceManager security certificate", u"DeviceManager的安全证书"],
    "18":["SSO security certificate", u"SSO的安全证书"],
    "20":["Object storage service security certificate", u"对象存储服务的安全证书"],
    "21":["Object storage service POE security certificate", u"对象存储服务帐户管理的安全证书"],
    "22":["Internal system service security certificate", u"系统内部服务的安全证书"],
    "23":["IAM security certificate", u"IAM的安全证书"],
    "24":["BSS security certificate", u"BSS的安全证书"],
    "25":["Keystone security certificate", u"Keystone的安全证书"],
    "29":["Unified communications security certificate", u"统一通信的安全证书"],
    "30":["One-time password email server authentication certificate", u"一次性口令邮件服务器认证证书"],
    "31":["KMS security certificate", u"KMS的安全证书"],
    "32":["DSwareTool security certificate", u"DSwareTool的安全证书"],
    "33":["Object storage service maintenance API security certificate", u"对象存储服务维护接口的安全证书"],
    "34":["FSM security certificate", u"FSM组件的安全证书"],
    "35":["FSA security certificate", u"FSA组件的安全证书"],
    "39":["Cold storage security certificate", u"冷存储的安全证书"],
    "62":["Internal KMS certificate", u"内置密钥管理服务证书"],
    "63":["CA server certificate", u"CA服务器证书"],
    "64":["PIM authentication certificate", u"PIM认证证书"],
    "66":["CCDB arbitration security certificate", u"CCDB仲裁的安全证书"],
    "67":["External KMS certificate", u"外置密钥管理服务证书"],
    "69":["Grafana service security certificate", u"Grafana服务的安全证书"],
    "73":["Heterogeneous device access certificate", u"异构设备接入证书"],
    "74":["Heterogeneous device service certificate", u"异构设备业务证书"],
    "80":["OceanStor 9000 access certificate", u"OceanStor 9000接入证书"],
}
# 800、801版本为双活仲裁证书，与其他版本名称不一致
# 803版本的对象存储服务ServiceLayer维护接口的安全证书，与其他版本名称不一致
TYPE_TO_CERT_NAME_EXT = {
    "3":["HyperMetro arbitration certificate", u"双活仲裁证书"],
    "33":["Object storage service layer maintenance API security certificate", u"对象存储服务ServiceLayer维护接口的安全证书"]
}
EXPIRING = "about to expire"
EXPIRED = "already expired"
# 大于180天，小于360天 EXPIRING
HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST = ""
HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST = ""

OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR = ""
OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR = ""

# 小于180天 EXPIRED
HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST = ""
HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST = ""

OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR = ""
OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR = ""

# 大于180天，小于360天 EXPIRING
HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST = ""
HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST = ""
# 小于180天 EXPIRED
HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST = ""
HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST = ""


class CertCheckResult(object):
    def __init__(self):
        self.check_result = ""
        self.ret_list = []
        self.cert_to_renew_list = []
        self.cert_need_renew_list = []
        self.ca_to_renew_list = []
        self.ca_need_renew_list = []


def patch_use_cert_content_by_type(ret_out, cert_type, cert_use):
    global HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST
    global HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST
    global OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR
    global OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR
    if ret_out == EXPIRING:
        if cert_type == "73":
            HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST = HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST + cert_use + ","
        elif cert_type == "74":
            HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST = HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST + cert_use + ","
        elif cert_type == "80":
            OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR = OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR + cert_use + ","
    elif ret_out == EXPIRED:
        if cert_type == "73":
            HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST = HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST + cert_use + ","
        elif cert_type == "74":
            HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST = HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST + cert_use + ","
        elif cert_type == "80":
            OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR = OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR + cert_use + ","


def patch_use_ca_content_by_type(ret_out, cert_type, cert_use):
    global HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST
    global HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST
    global OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR
    global OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR
    if ret_out == EXPIRING:
        if cert_type == "73":
            HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST = HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST + cert_use + ","
        elif cert_type == "74":
            HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST = HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST + cert_use + ","
        elif cert_type == "80":
            OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR = OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR + cert_use + ","        
    elif ret_out == EXPIRED:
        if cert_type == "73":
            HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST = HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST + cert_use + ","
        elif cert_type == "74":
            HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST = HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST + cert_use + ","
        elif cert_type == "80":
            OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR = OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR + cert_use + ","


def fill_heterogeneous_access_content(check_cert_result):
    global HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST
    global HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST
    global HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST
    global HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST
    if len(HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST) != 0:
        HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST = HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device access certificate" +  \
            "(Use:" + HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST + ")"
        cert_name_zh = "异构设备接入证书" + "(Use:" + HETEROGENEOUS_ACCESS_CERT_TO_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRING, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST) != 0:
        HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST = HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device access certificate" +  \
            "(Use:" + HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST + ")"
        cert_name_zh = "异构设备接入证书" + "(Use:" + HETEROGENEOUS_ACCESS_CA_TO_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRING, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST) != 0:
        HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST = HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device access certificate" +  \
            "(Use:" + HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST + ")"
        cert_name_zh = "异构设备接入证书" + "(Use:" + HETEROGENEOUS_ACCESS_CERT_NEED_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRED, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST) != 0:
        HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST = HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device access certificate" +  \
            "(Use:" + HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST + ")"
        cert_name_zh = "异构设备接入证书" + "(Use:" + HETEROGENEOUS_ACCESS_CA_NEED_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRED, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
            cert_name_en, cert_name_zh)


def fill_oceanstor_access_str(check_cert_result, oceanstor_str, expire, cert_type=""):
    origin_cert_name_en = "OceanStor 9000 access certificate(Use:{})"
    origin_cert_name_zh = "OceanStor 9000接入证书(Use:{})"
    if len(oceanstor_str) != 0:
        oceanstor_str = oceanstor_str[:-1]
        cert_name_en = origin_cert_name_en.format(oceanstor_str)
        cert_name_zh = origin_cert_name_zh.format(oceanstor_str)
        if cert_type == "ca":
            renew_err_list_by_ret(expire, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
                cert_name_en, cert_name_zh)
        else:
            renew_err_list_by_ret(expire, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
            cert_name_en, cert_name_zh)


def fill_oceanstor_access_content(check_cert_result):

    global OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR
    global OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR
    global OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR
    global OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR
    fill_oceanstor_access_str(check_cert_result, OCEANSTOR9000_ACCESS_CERT_TO_RENEW_STR, EXPIRING)
    fill_oceanstor_access_str(check_cert_result, OCEANSTOR9000_ACCESS_CA_TO_RENEW_STR, EXPIRING, "ca")
    fill_oceanstor_access_str(check_cert_result, OCEANSTOR9000_ACCESS_CERT_NEED_RENEW_STR, EXPIRED)
    fill_oceanstor_access_str(check_cert_result, OCEANSTOR9000_ACCESS_CA_NEED_RENEW_STR, EXPIRED, "ca")


def fill_heterogeneous_service_content(check_cert_result):
    global HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST
    global HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST
    if len(HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST) != 0:
        HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST = HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device service certificate" + \
            "(Use:" + HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST + ")"
        cert_name_zh = "异构设备业务证书" + "(Use:" + HETEROGENEOUS_SERVICE_CERT_TO_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRING, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST) != 0:
        HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST = HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device service certificate" + \
            "(Use:" + HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST + ")"
        cert_name_zh = "异构设备业务证书" + "(Use:" + HETEROGENEOUS_SERVICE_CA_TO_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRING, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST) != 0:
        HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST = HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device service certificate" + \
            "(Use:" + HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST + ")"
        cert_name_zh = "异构设备业务证书" + "(Use:" + HETEROGENEOUS_SERVICE_CERT_NEED_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRED, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
            cert_name_en, cert_name_zh)
    if len(HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST) != 0:
        HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST = HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST[:-1]
        cert_name_en = "Heterogeneous device service certificate" + \
            "(Use:" + HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST + ")"
        cert_name_zh = "异构设备业务证书" + "(Use:" + HETEROGENEOUS_SERVICE_CA_NEED_RENEW_LIST + ")"
        renew_err_list_by_ret(EXPIRED, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
            cert_name_en, cert_name_zh)


def execute(rest):
    """
    检查证书是否过期
    :param env:
    :return:
    """
    check_cert_result = CertCheckResult()
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        device_esn = dev_node.getDeviceSerialNumber()

        # 获取系统UTC时间
        cmd_str = "{}/deviceManager/rest/{}/system_utc_time".format(base_uri, device_esn)
        check_cert_result.ret_list.append(cmd_str)
        time_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        check_cert_result.ret_list.append(str(time_json))
        if not time_json.get("data"):
            return common.INSPECT_UNNORMAL, "\n".join(check_cert_result.ret_list), \
                   common.get_err_msg(LANG, "query.result.abnormal")
        cur_timestamp = int(time_json.get("data").get("CMO_SYS_UTC_TIME"))

        # 查询证书信息
        cmd_str = "{}/deviceManager/rest/{}/certificate".format(base_uri, device_esn)
        check_cert_result.ret_list.append(cmd_str)
        rsp_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        check_cert_result.ret_list.append(str(rsp_json))
        if not rsp_json.get("data"):
            return (common.INSPECT_UNNORMAL, "\n".join(check_cert_result.ret_list),
                    common.get_err_msg(LANG, "query.result.abnormal"))

        check_cert_result.check_result = common.INSPECT_PASS
        certificates_info = rsp_json.get("data", [])
        check_cert_expired_by_time(certificates_info, cur_timestamp, check_cert_result)
        # 填充异构证书信息
        fill_heterogeneous_access_content(check_cert_result)
        fill_heterogeneous_service_content(check_cert_result)
        fill_oceanstor_access_content(check_cert_result)
        # 如果没有证书或CA过期，需要填充信息
        fill_all_err_list(check_cert_result)

        return get_ret_info_by_check_result(check_cert_result)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
    return (
        common.INSPECT_UNNORMAL,
        "\n".join(check_cert_result.ret_list),
        common.get_err_msg(LANG, "query.result.abnormal"),
    )


def get_ret_info_by_check_result(check_cert_result):
    if check_cert_result.check_result == common.INSPECT_PASS:
        return common.INSPECT_PASS, "\n".join(check_cert_result.ret_list), ""
    elif check_cert_result.check_result == common.INSPECT_WARNING:
        return common.INSPECT_WARNING, "\n".join(check_cert_result.ret_list), \
               common.get_err_msg(LANG, "cert.expire",
                                  (",".join(check_cert_result.cert_to_renew_list),
                                   ",".join(check_cert_result.ca_to_renew_list),
                                   ",".join(check_cert_result.cert_need_renew_list),
                                   ",".join(check_cert_result.ca_need_renew_list))
                                  )
    else:
        return common.INSPECT_UNNORMAL, "\n".join(check_cert_result.ret_list), \
               common.get_err_msg(LANG, "cert.expire",
                                  (",".join(check_cert_result.cert_to_renew_list),
                                   ",".join(check_cert_result.ca_to_renew_list),
                                   ",".join(check_cert_result.cert_need_renew_list),
                                   ",".join(check_cert_result.ca_need_renew_list))
                                  )


def check_cert_expired_by_time(certificates_info, cur_timestamp, check_cert_result):
    for record in certificates_info:
        # 证书过期检查
        cert_flag = check_cert_by_time(cur_timestamp, record, check_cert_result)

        # CA证书过期检查
        check_ca_by_time(cur_timestamp, check_cert_result, record, cert_flag)


def check_cert_by_time(cur_time, record, check_cert_result):
    # 获取证书过期时间
    cert_expire_time = record.get("CERTIFICATE_EXPIRE_TIME")
    if cert_expire_time == "--":
        return True
    cert_type = record.get("CERTIFICATE_TYPE")
    cert_use = record.get("USE_OF_CERTIFICATE", "notexist")
    cert_name_en, cert_name_zh = get_cert_name_by_type(cert_type)
    # 转换成时间数组
    cert_expire_time_array = time.strptime(cert_expire_time, "%Y-%m-%d")
    # 时间数组转换成时间戳
    cert_expire_timestamp = int(time.mktime(cert_expire_time_array))
    cert_flag, ret_out = check_cert_time(cur_time, cert_expire_timestamp)
    if not cert_flag:
        set_result_by_ret(ret_out, check_cert_result)
        if cert_type not in ["73", "74", "80"]:
            renew_err_list_by_ret(ret_out, check_cert_result.cert_to_renew_list, check_cert_result.cert_need_renew_list,
                                cert_name_en, cert_name_zh)
        check_cert_result.ret_list.append("")
        check_cert_result.ret_list.append(CERT_TRPE + ":" + cert_name_en)
        check_cert_result.ret_list.append(EXPIRE_TIME + ":" + cert_expire_time)
        check_cert_result.ret_list.append(CERT_ISSUSER + ":" + record.get("CERTIFICATE_ISSUER"))
        check_cert_result.ret_list.append(CERT_SUBJECT + ":" + record.get("CERTIFICATE_SUBJECT"))
        if cert_use != "notexist":
            check_cert_result.ret_list.append(USE_OF_CERTIFICATE + ":" + cert_use)
            if cert_type in ["73", "74", "80"]:
                patch_use_cert_content_by_type(ret_out, cert_type, cert_use)
    return cert_flag


def check_ca_by_time(cur_time, check_cert_result, record, cert_flag):
    # 获取CA证书过期时间
    ca_expire_time = record.get("CA_CERTIFICATE_EXPIRE_TIME")
    if ca_expire_time == "--":
        return
    cert_type = record.get("CERTIFICATE_TYPE")
    cert_use = record.get("USE_OF_CERTIFICATE", "notexist")
    cert_name_en, cert_name_zh = get_cert_name_by_type(cert_type)
    # 转换成时间数组
    ca_expire_time_array = time.strptime(ca_expire_time, "%Y-%m-%d")
    # 时间数组转换成时间戳
    ca_expire_timestamp = int(time.mktime(ca_expire_time_array))
    ca_flag, ret_out = check_cert_time(cur_time, ca_expire_timestamp)
    if not ca_flag:
        set_result_by_ret(ret_out, check_cert_result)
        if cert_type not in ["73", "74", "80"]:
            renew_err_list_by_ret(ret_out, check_cert_result.ca_to_renew_list, check_cert_result.ca_need_renew_list,
                                cert_name_en, cert_name_zh)
        # 证书没过期的话，此处需要打印证书类型
        if cert_flag:
            check_cert_result.ret_list.append("")
            check_cert_result.ret_list.append(CERT_TRPE + ":" + cert_name_en)
        check_cert_result.ret_list.append(CA_EXPIRE_TIME + ":" + ca_expire_time)
        check_cert_result.ret_list.append(CERT_ISSUSER + ":" + record.get("CA_CERTIFICATE_ISSUER"))
        check_cert_result.ret_list.append(CERT_SUBJECT + ":" + record.get("CA_CERTIFICATE_SUBJECT"))
        if cert_use != "notexist":
            check_cert_result.ret_list.append(USE_OF_CERTIFICATE + ":" + cert_use)
            if cert_type in ["73", "74", "80"]:
                patch_use_ca_content_by_type(ret_out, cert_type, cert_use)


def check_cert_time(cur_timestamp, expire_timestamp):
    time_till_expire = expire_timestamp - cur_timestamp
    """
    180<expire_time_dif_days<365 为建议优化
    time_till_expire <= 180天 为不通过

    @param expire_time_dif_days: 差异天数
    @return: 结果
    """
    if time_till_expire >= (365 * 24 * 60 * 60):
        return True, ""
    elif time_till_expire > (180 * 24 * 60 * 60) and time_till_expire < (365 * 24 * 60 * 60):
        return False, EXPIRING
    else:
        return False, EXPIRED


def set_result_by_ret(ret, check_cert_result):
    if ret == EXPIRING:
        # 如果没有证书检查不通过，才报建议修改
        if check_cert_result.check_result != common.INSPECT_UNNORMAL:
            check_cert_result.check_result = common.INSPECT_WARNING
    elif ret == EXPIRED:
        check_cert_result.check_result = common.INSPECT_UNNORMAL


def renew_err_list_by_ret(ret, cert_to_renew_list, cert_need_renew_list, cert_name_en, cert_name_zh):
    if ret == EXPIRING:
        renew_err_list(LANG, cert_to_renew_list, cert_name_en, cert_name_zh)
    elif ret == EXPIRED:
        renew_err_list(LANG, cert_need_renew_list, cert_name_en, cert_name_zh)


def renew_err_list(lang, cert_list, cert_name_en, cert_name_zh):
    if lang == "zh":
        if len(cert_list) == 0:
            cert_list.append(cert_name_zh)
        else:
            cert_list.append(u" " + cert_name_zh)
    else:
        if len(cert_list) == 0:
            cert_list.append(cert_name_en)
        else:
            cert_list.append(" " + cert_name_en)


def fill_all_err_list(check_cert_result):
    fill_err_list(LANG, 0, check_cert_result.cert_to_renew_list)
    fill_err_list(LANG, 0, check_cert_result.cert_need_renew_list)
    fill_err_list(LANG, 1, check_cert_result.ca_to_renew_list)
    fill_err_list(LANG, 1, check_cert_result.ca_need_renew_list)


def fill_err_list(lang, certificate_type, cert_list):
    if lang == "zh":
        if len(cert_list) == 0:
            if certificate_type == 0:
                cert_list.append(u"无即将过期证书")
            else:
                cert_list.append(u"无即将过期CA证书")
    else:
        if len(cert_list) == 0:
            if certificate_type == 0:
                cert_list.append("No certificate which is about to expire")
            else:
                cert_list.append("No CA certificate which is about to expire")


def get_cert_name_by_type(cert_type):
    cert_name_en = ""
    cert_name_zh = ""
    if cert_type in TYPE_TO_CERT_NAME:
        cert_name_en, cert_name_zh = TYPE_TO_CERT_NAME[cert_type]

    if cert_type in TYPE_TO_CERT_NAME_EXT:
        dev_node = py_java_env.get("devInfo")
        product_version = str(dev_node.getProductVersion())
        version = product_version.replace('.', "")
        # 特殊处理，证书名在800、801版本不同
        if version[0:3] in ("800", "801") and cert_type == "3":
            cert_name_en, cert_name_zh = TYPE_TO_CERT_NAME_EXT[cert_type]
        # 特殊处理，证书名在803版本不同
        if version[0:3] == "803" and cert_type == "33":
            cert_name_en, cert_name_zh = TYPE_TO_CERT_NAME_EXT[cert_type]

    return cert_name_en, cert_name_zh
