# coding: UTF-8
import json

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_cluster_nodes_total_length"
MAX_PIPE_NUM = 65536


def execute(rest):
    """
    检查节点ip长度
    :param env:
    :return:
    """
    LOGGER.logInfo("start to check cluster nodes total length.")
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_dic = {}
    try:
        progress_dic[ITEM_ID] = 1
        observer.updateProgress(progress_dic)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/cluster/product".format(base_uri)
        ret_list.append(cmd_str)
        pro_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(json.dumps(pro_json)))
        if not pro_json.get("data"):
            return common.INSPECT_PASS, "\n".join(ret_list), ""
        version = pro_json.get("data").get("version")
        hotpatch_version = pro_json.get("data").get("hotpatch_version", None)
        LOGGER.logInfo("cluster version is {} {}.".format(version, hotpatch_version))
        # 版本小于8.1.2.SPH115
        if "8.1.2" not in version:
            return common.INSPECT_NOSUPPORT, "\n".join(ret_list), ""
        if hotpatch_version:
            version_sph = int(hotpatch_version.split("8.1.2.SPH")[1])
            if version_sph > 115:
                return common.INSPECT_NOSUPPORT, "\n".join(ret_list), ""

        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/server/queryAllHost".format(base_uri)
        ret_list.append(cmd_str)
        node_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(json.dumps(node_json)))
        if not node_json.get("hostInfoList"):
            return common.INSPECT_PASS, "\n".join(ret_list), ""

        progress_dic[ITEM_ID] = 50
        observer.updateProgress(progress_dic)
        length = cal_node_length(node_json)
        ret_list.append("The cluster node ip total length is {}".format(length))
        LOGGER.logInfo("cluster node length is %s.", length)
        if length >= MAX_PIPE_NUM:
            err_info = "The total length of cluster nodes is greater than 65535, please contact technical support."
            LOGGER.logError(err_info)
            key = "check_cluster_nodes_total_length.not.pass"
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, key)
        return common.INSPECT_PASS, "\n".join(ret_list), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")


def cal_node_length(node_json):
    # 构造输出字典
    switch_map = {}
    hosts = node_json.get("hostInfoList", [])
    for host in hosts:
        cluster_ip = host.get('ctrlIp')
        if len(cluster_ip) == 0:
            cluster_ip = host.get('clusterIp')
        manage_ip = host.get('manageIp')
        switch_map[manage_ip] = cluster_ip

    length = 41
    for key, value in switch_map.items():
        length = length + len(key) + len(value) + 12
    return length
