# coding: UTF-8
import re
import json
from ds_rest_util import CommonRestService
from com.huawei.ism.exception import IsmException
import common

ITEM_ID = "check_disk_forcewb"
PRE_ITEM_ID = "forcewbInfo"
HANDLE = py_java_env.get("preInspectHandle")
PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(rest):
    check_item = CheckDiskForcewb(rest, PY_JAVA_ENV, LANG, LOGGER)
    return check_item.execute_check()


class CheckDiskForcewb:
    def __init__(self, rest, env, lang, logger):
        self.rest = rest
        self.lang = lang
        self.env = env
        self.observer = env.get("progressObserver")
        self.logger = logger
        self.ret_list = []
        self.progress_map = {}
        self.result = ""
        self.dev_node = self.env.get("devInfo")
        import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
        self.base_uri = RestUtil.getDstorageUrlHead(self.dev_node)
        self.all_selected_nodes = []
        self.all_manage_nodes = []
        self.all_storage_nodes = []
        self.need_check_disk_pools_id_set = set()
        self.need_check_storage_pools_id_set = set()

    @staticmethod
    def check_in_forcewb_whitelist(phy_dev_model, forcewb_whilelist_arr):
        for forcewb_item in forcewb_whilelist_arr:
            if (phy_dev_model == forcewb_item):
                return True
        return False

    @staticmethod
    def get_forcewb_whitelist(pre_inpect_result):
        forcewb_whitelist_pattern = 'FORCEWB_WHITELIST=(.*)"]}]'
        forcewb_whitelist_match = re.search(forcewb_whitelist_pattern, pre_inpect_result)
        return forcewb_whitelist_match.group(1).split(",")

    @staticmethod
    def is_old_product_version(product_version):
        version = product_version.replace('.', "")
        if version[0:2] == "80" and version[2].isdigit() and version[2] <= "1":
            return True
        return False

    @staticmethod
    def no_need_checked_version(product_version):
        version = product_version.replace('.', "")
        if version[0:2] == "80" and version[2].isdigit():
            if version[2] == "2" or version[2] == "3":
                return True
            if version[2:4] == "14":
                return True
        return False

    @staticmethod
    def get_service_type(diskpools_json):
        disk_pools = diskpools_json.get("diskPools", [])
        return disk_pools[0].get("serviceType")

    @staticmethod
    def get_disk_pools_id_list(diskpools_json):
        disk_pools = diskpools_json.get("diskPools", [])
        disk_pools_id_list = []
        for disk_pool in disk_pools:
            pool_id = disk_pool.get("poolId")
            if pool_id is None:
                continue
            disk_pools_id_list.append(pool_id)
        return disk_pools_id_list

    @staticmethod
    def get_storage_pools_id_list_for_old_version(storage_pools_json):
        storage_pools = storage_pools_json.get("storagePools", [])
        storage_pools_id_list = []
        for storage_pool in storage_pools:
            pool_id = storage_pool.get("poolId")
            if pool_id is None:
                continue
            storage_pools_id_list.append(pool_id)
        return storage_pools_id_list

    @staticmethod
    def get_node_ip_and_disk_pool_id_dict(disk_model_json, node_ip, node_ip_and_disk_pool_id_dict):
        pool_ids_set = set()
        dev_list = disk_model_json.get("servers", []).get(node_ip, [])
        for dev in dev_list:
            pool_ids_list = dev.get("poolIds", [])
            for pool_id in pool_ids_list:
                pool_ids_set.add(pool_id)
        node_ip_and_disk_pool_id_dict[node_ip] = pool_ids_set
        return node_ip_and_disk_pool_id_dict

    def execute_check(self):
        try:
            self.update_progress(1)
            self.logger.logInfo("begin to check disk forcewb, got dev_node : {}".format(self.dev_node))
            product_version = str(self.dev_node.getProductVersion())

            self.get_role_ips()
            self.logger.logInfo("got manage_nodes : {}, storage_nodes:{}" \
                                .format(self.all_manage_nodes, self.all_storage_nodes))
            if not self.all_manage_nodes:
                self.process_result_all_nosupport()
                self.logger.logWarning("No management node is selected.")
                return common.INSPECT_NOSUPPORT, "\n".join(self.ret_list), ""

            pre_inspect_result = None
            for node_ip in self.all_manage_nodes:
                pre_inspect_result = HANDLE.getPreInspectResult(node_ip, PRE_ITEM_ID)
            self.logger.logInfo("got pre_inpect_result : {}".format(pre_inspect_result))
            if not pre_inspect_result:
                self.logger.logWarning("pre_inpect_result is none.")
                self.process_result_all_nosupport()
                return common.INSPECT_NOSUPPORT, "\n".join(self.ret_list), ""
            forcewb_whilelist_arr = self.get_forcewb_whitelist(pre_inspect_result)
            self.logger.logInfo("got forcewb_whilelist_arr : {}".format(forcewb_whilelist_arr))

            if self.no_need_checked_version(product_version):
                self.logger.logInfo("Passed the forcewb check. {} do not need to be checked.".format(product_version))
                self.ret_list.append("The version is not involved.")
                return common.INSPECT_PASS, "\n".join(self.ret_list), ""
            if self.is_old_product_version(product_version):
                return self.check_disk_forcewb_for_old_version(forcewb_whilelist_arr)
            return self.check_disk_forcewb_for_new_version(forcewb_whilelist_arr)
        except (IsmException, Exception) as exception:
            self.logger.logException(exception)
            self.ret_list.append("An exception occurs during the inspection.")
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""

    def update_progress(self, number):
        self.progress_map[ITEM_ID] = number
        self.observer.updateProgress(self.progress_map)

    def get_role_ips(self):
        for cluster_node in self.dev_node.getClusterNodes():
            if cluster_node.isSelected():
                self.all_selected_nodes.append(common.get_node_ip(cluster_node))
                if cluster_node.includeManagementRole():
                    self.all_manage_nodes.append(common.get_node_ip(cluster_node))
            if cluster_node.includedStorageService():
                self.all_storage_nodes.append(common.get_node_ip(cluster_node))

    def get_storage_pools_for_old_version(self):
        cmd_str = "{}/dsware/service/cluster/storagepool/queryStoragePool".format(self.base_uri)
        storage_pools_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return storage_pools_json

    def get_storage_pools_info_parameters_for_old_version(self, storage_pool_id):
        cmd_str = "{}/dsware/service/cluster/storagepool/queryPoolParametersOperation?poolId={}"\
            .format(self.base_uri, storage_pool_id)
        storage_pools_info_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return storage_pools_info_json.get("parameter", [])

    def get_node_info_for_old_version(self, storage_pool_id):
        cmd_str = "{}/dsware/service/cluster/storagepool/queryNodeDiskInfo?poolId={}"\
            .format(self.base_uri, storage_pool_id)
        node_info_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return node_info_json.get("nodeInfo", [])

    def get_storage_pool_info_arr_for_old_version(self, pool_id):
        cmd_str = "{}/dsware/service/cluster/storagepool/queryStoragePool?poolId={}".format(self.base_uri, pool_id)
        disk_model_info_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        storage_pool_info_arr = disk_model_info_json.get("storagePools", [])
        return storage_pool_info_arr

    def check_disk_forcewb_for_old_version(self, forcewb_whilelist_arr):
        storage_pools_json = self.get_storage_pools_for_old_version()
        if not storage_pools_json.get("storagePools"):
            self.logger.logInfo("Passed the forcewb check. No storage pool exists.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(15)

        storage_pools_id_list = self.get_storage_pools_id_list_for_old_version(storage_pools_json)
        all_force_wb_switch_flag = self.check_forcewb_switch_for_old_version(storage_pools_id_list)
        if all_force_wb_switch_flag:
            self.logger.logInfo("Passed the forcewb check. p_osd_force_wb_switch is open.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(30)

        all_node_info_flag = self.check_node_info_for_old_version()
        if all_node_info_flag:
            self.logger.logInfo("Passed the forcewb check. Failed to query cache disk info.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(45)

        all_disk_model_flag, node_ip_and_disk_pool_id_dict = self.check_disk_model_for_old_version()
        if (all_disk_model_flag):
            self.logger.logInfo("Passed the forcewb check. Failed to query cache disk model info.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(60)

        all_phy_dev_model_flag = self.check_phy_dev_model_for_old_version(forcewb_whilelist_arr)
        if all_phy_dev_model_flag:
            not_supported_forcewb_log_info = \
                "Passed the forcewb check. The forcewb feature cannot be enabled for cache disks."
            self.logger.logInfo(not_supported_forcewb_log_info)
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(80)

        return self.check_storage_cache_rate_for_old_version(storage_pools_id_list)

    def check_phy_dev_model_for_old_version(self, forcewb_whilelist_arr):
        all_phy_dev_model_flag = True
        phy_dev_disk_model_to_remove_set = set()
        self.logger.logInfo("before query phyDevModel, need_check_storage_pools_id_set : {}" \
                            .format(self.need_check_storage_pools_id_set))
        for node_ip in self.all_storage_nodes:
            disk_model_json = self.get_disk_model_json_single_node(node_ip)
            overlap_disk_pools_id_set = self.get_overlap_disk_pools_id_set_for_old_version(disk_model_json, node_ip)
            server_list = disk_model_json.get("servers", [])
            server_info_list = server_list.get(node_ip, [])
            single_node_phy_dev_model_flag = False
            for server_info in server_info_list:
                phy_dev_model = str(server_info.get("phyDevModel"))
                self.logger.logInfo("got phyDevModel : {}".format(phy_dev_model))
                if (not self.check_in_forcewb_whitelist(phy_dev_model, forcewb_whilelist_arr)):
                    continue
                else:
                    # 节点中存在白名单内的缓存盘
                    single_node_phy_dev_model_flag = True
            if (single_node_phy_dev_model_flag):
                all_phy_dev_model_flag = False
            else:
                phy_dev_disk_model_to_remove_set.update(overlap_disk_pools_id_set)
        self.logger.logInfo("phy_dev_disk_model_to_remove_set : {}".format(phy_dev_disk_model_to_remove_set))
        self.logger.logInfo("before diff phy_dev_disk_model_to_remove_set, need_check_storage_pools_id_set : {}"\
                            .format(self.need_check_storage_pools_id_set))
        self.need_check_storage_pools_id_set -= phy_dev_disk_model_to_remove_set
        return all_phy_dev_model_flag

    def check_disk_model_for_old_version(self):
        disk_model_to_remove_set = set()
        node_ip_and_disk_pool_id_dict = {}
        all_disk_model_flag = True
        self.logger.logInfo("before check_disk_model_for_old_version, need_check_storage_pools_id_set : {}" \
                            .format(self.need_check_storage_pools_id_set))
        for node_ip in self.all_storage_nodes:
            disk_model_json = self.get_disk_model_json_single_node(node_ip)
            node_ip_and_disk_pool_id_dict =\
                self.get_node_ip_and_disk_pool_id_dict(disk_model_json, node_ip, node_ip_and_disk_pool_id_dict)
            self.logger.logInfo("got disk_model_json : {} from node : {}".format(disk_model_json, node_ip))
            overlap_disk_pools_id_set = self.get_overlap_disk_pools_id_set_for_old_version(disk_model_json, node_ip)
            if (len(overlap_disk_pools_id_set) == 0):
                continue
            elif (disk_model_json.get("result") != 0):
                # 移除已经查询失败的
                disk_model_to_remove_set.update(overlap_disk_pools_id_set)
            else:
                all_disk_model_flag = False
        self.need_check_storage_pools_id_set -= disk_model_to_remove_set
        self.logger.logInfo("when check_disk_model_for_old_version, disk_model_to_remove_set : {}" \
                            .format(disk_model_to_remove_set))
        self.logger.logInfo("after check_disk_model_for_old_version, need_check_storage_pools_id_set : {}" \
                            .format(self.need_check_storage_pools_id_set))
        return all_disk_model_flag, node_ip_and_disk_pool_id_dict

    def check_node_info_for_old_version(self):
        node_info_to_remove_set = set()
        all_node_info_flag = True
        self.logger.logInfo("before check_node_info_for_old_version, need_check_storage_pools_id_set : {}" \
                            .format(self.need_check_storage_pools_id_set))
        for storage_pool_id in self.need_check_storage_pools_id_set:
            node_info = self.get_node_info_for_old_version(storage_pool_id)
            self.logger.logInfo("got node_info : {}".format(node_info))
            for node_info in node_info:
                if (node_info.get("errorCode") != 0):
                    node_info_to_remove_set.add(storage_pool_id)
                else:
                    all_node_info_flag = False
        self.need_check_disk_pools_id_set -= node_info_to_remove_set
        self.logger.logInfo("when check_node_info_for_old_version, node_info_to_remove_set : {}" \
                            .format(node_info_to_remove_set))
        self.logger.logInfo("after check_node_info_for_old_version, need_check_storage_pools_id_set : {}" \
                            .format(self.need_check_storage_pools_id_set))
        return all_node_info_flag

    def check_forcewb_switch_for_old_version(self, storage_pools_id_list):
        all_force_wb_switch_flag = True
        for storage_pool_id in storage_pools_id_list:
            storage_pools_info_parameters = self.get_storage_pools_info_parameters_for_old_version(storage_pool_id)
            self.logger.logInfo("got storage_pools_info_parameters : {}".format(storage_pools_info_parameters))
            for parameter in storage_pools_info_parameters:
                if (parameter.get("paraName") != "p_osd_force_wb_switch"):
                    continue
                elif (parameter.get("value") == "open"):
                    continue
                else:
                    all_force_wb_switch_flag = False
                    self.need_check_storage_pools_id_set.add(storage_pool_id)
        self.logger.logInfo("need_check_storage_pools_id_set : {}".format(self.need_check_storage_pools_id_set))
        return all_force_wb_switch_flag

    def check_storage_cache_rate_for_old_version(self, storage_pools_id_list):
        abnormal_pool_id_set = set()
        all_force_wb_flag = True
        self.logger.logInfo("need_check_storage_pools_id_set : {}when checking storahe_cache_rate" \
                            .format(self.need_check_storage_pools_id_set))
        for storage_pool_id in storage_pools_id_list:
            if (storage_pool_id in self.need_check_storage_pools_id_set):
                storage_cache_rate = self.get_storage_cache_rate_for_old_version(storage_pool_id)
                self.logger.logInfo("The storageCacheRate = {} from storage pool ({})." \
                                    .format(storage_cache_rate, storage_pool_id))
                if ((not storage_cache_rate) or float(storage_cache_rate) <= 0.03):
                    continue
                else:
                    all_force_wb_flag = False
                    abnormal_pool_id_set.add(storage_pool_id)
        if (all_force_wb_flag):
            self.logger.logInfo("Passed the forcewb check.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        else:
            self.logger.logWarning("check disk forcewb finished. Recommended Optimization.")
            err_code = "check_disk_forcewb.result.not.pass"
            self.process_result_abnormal(abnormal_pool_id_set)
            return common.INSPECT_WARNING, "\n".join(self.ret_list), \
                common.get_err_msg(self.lang, err_code, ",".join(self.all_manage_nodes))

    def get_storage_cache_rate_for_old_version(self, storage_pool_id):
        cmd_str = "{}/dsware/service/{}/storagePool?poolId={}".format(self.base_uri, "v1", storage_pool_id)
        storage_pools_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        storage_pool_info = storage_pools_json.get("storagePools", [])[0]
        return float(storage_pool_info.get("storageCacheRate"))

    def check_disk_forcewb_for_new_version(self, forcewb_whilelist_arr):
        diskpools_json = self.get_disk_pools_json()
        if not diskpools_json.get("diskPools"):
            self.logger.logInfo("Passed the forcewb check. No disk pool exists.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(15)

        # 非块池直接通过
        if (self.get_service_type(diskpools_json) != 1):
            self.logger.logInfo("Passed the forcewb check. Not block type.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""

        self.logger.logInfo("diskpools_json : {}".format(diskpools_json))
        disk_pools_id_list = self.get_disk_pools_id_list(diskpools_json)
        self.logger.logInfo("disk_pools_id_list: {}".format(disk_pools_id_list))
        all_force_wb_switch_flag = self.check_forcewb_switch(disk_pools_id_list)
        if all_force_wb_switch_flag:
            self.logger.logInfo("Passed the forcewb check. p_osd_force_wb_switch is open.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(30)

        all_node_info_flag = self.check_node_info()
        if all_node_info_flag:
            self.logger.logInfo("Passed the forcewb check. Failed to query cache disk info.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(45)

        all_disk_model_flag = self.check_disk_model()
        if (all_disk_model_flag):
            self.logger.logInfo("Passed the forcewb check. Failed to query cache disk model info.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(60)

        all_phy_dev_model_flag = self.check_phy_dev_model(forcewb_whilelist_arr)
        if all_phy_dev_model_flag:
            not_supported_forcewb_log_info = \
                "Passed the forcewb check. The forcewb feature cannot be enabled for cache disks."
            self.logger.logInfo(not_supported_forcewb_log_info)
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        self.update_progress(80)

        return self.check_storage_cache_rate()

    def process_result_normal(self):
        msg = ''
        selected_not_manage_nodes = list(set(self.all_selected_nodes) - set(self.all_manage_nodes))
        for node_ip in self.all_manage_nodes:
            msg = msg + common.get_err_msg(self.lang, "check_disk_forcewb_result.node.normal", node_ip)
        for node_ip in selected_not_manage_nodes:
            msg = msg + common.get_err_msg(self.lang, "check_disk_forcewb_result.node.no.support", node_ip)
        self.ret_list.append(msg.encode("utf-8").decode("utf-8"))

    def process_result_all_nosupport(self):
        msg = ''
        for node_ip in self.all_selected_nodes:
            msg = msg + common.get_err_msg(self.lang, "check_disk_forcewb_result.node.no.support", node_ip)
        self.ret_list.append(msg.encode("utf-8").decode("utf-8"))

    def check_phy_dev_model(self, forcewb_whilelist_arr):
        all_phy_dev_model_flag = True
        phy_dev_disk_model_to_remove_set = set()
        self.logger.logInfo("before query phyDevModel, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        for node_ip in self.all_storage_nodes:
            disk_model_json = self.get_disk_model_json_single_node(node_ip)
            overlap_disk_pools_id_set = self.get_overlap_disk_pools_id_set(disk_model_json, node_ip)
            server_list = disk_model_json.get("servers", [])
            server_info_list = server_list.get(node_ip, [])
            single_node_phy_dev_model_flag = False
            for server_info in server_info_list:
                phy_dev_model = str(server_info.get("phyDevModel"))
                self.logger.logInfo("got phyDevModel : {}".format(phy_dev_model))
                # 只要存在白名单内的缓存盘，就要继续进行下一步的校验
                if (not self.check_in_forcewb_whitelist(phy_dev_model, forcewb_whilelist_arr)):
                    continue
                else:
                    single_node_phy_dev_model_flag = True
            # 若单节点存在缓存盘在白名单内，需要继续检查，否则不需要继续巡检该节点下的缓存盘
            if (single_node_phy_dev_model_flag) :
                all_phy_dev_model_flag = False
            else:
                phy_dev_disk_model_to_remove_set.update(overlap_disk_pools_id_set)
        self.logger.logInfo("phy_dev_disk_model_to_remove_set : {}".format(phy_dev_disk_model_to_remove_set))
        self.logger.logInfo("before diff phy_dev_disk_model_to_remove_set, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        self.need_check_disk_pools_id_set -= phy_dev_disk_model_to_remove_set
        return all_phy_dev_model_flag

    def get_overlap_disk_pools_id_set_for_old_version(self, disk_model_json, node_ip):
        overlap_disk_pools_id_set = set()
        server_list = disk_model_json.get("servers", [])
        if server_list is None:
            return overlap_disk_pools_id_set
        server_info_list = server_list.get(node_ip, [])
        for server_info in server_info_list:
            pool_id_list = server_info.get("poolIds", [])
            for pool_id in pool_id_list:
                if (pool_id in self.need_check_storage_pools_id_set):
                    overlap_disk_pools_id_set.add(pool_id)
        self.logger.logInfo("overlap_disk_pools_id_set : {}".format(overlap_disk_pools_id_set))
        return overlap_disk_pools_id_set

    def get_overlap_disk_pools_id_set(self, disk_model_json, node_ip):
        overlap_disk_pools_id_set = set()
        server_list = disk_model_json.get("servers", [])
        if server_list is None:
            return overlap_disk_pools_id_set
        server_info_list = server_list.get(node_ip, [])
        for server_info in server_info_list:
            pool_id_list = server_info.get("poolIds", [])
            for pool_id in pool_id_list:
                if (pool_id in self.need_check_disk_pools_id_set):
                    overlap_disk_pools_id_set.add(pool_id)
        self.logger.logInfo("overlap_disk_pools_id_set : {}".format(overlap_disk_pools_id_set))
        return overlap_disk_pools_id_set

    def check_disk_model(self):
        disk_model_to_remove_set = set()
        all_disk_model_flag = True
        self.logger.logInfo("before check_disk_model, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        for node_ip in self.all_storage_nodes:
            disk_model_json = self.get_disk_model_json_single_node(node_ip)
            self.logger.logInfo("got disk_model_json : {} from node : {}".format(disk_model_json, node_ip))
            overlap_disk_pools_id_set = self.get_overlap_disk_pools_id_set(disk_model_json, node_ip)
            if (len(overlap_disk_pools_id_set) == 0):
                continue
            elif (disk_model_json.get("result") != 0):
                disk_model_to_remove_set.update(overlap_disk_pools_id_set)
            else:
                all_disk_model_flag = False
        self.need_check_disk_pools_id_set -= disk_model_to_remove_set
        self.logger.logInfo("when check_disk_model, disk_model_to_remove_set : {}" \
                            .format(disk_model_to_remove_set))
        self.logger.logInfo("after check_disk_model, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        return all_disk_model_flag

    def check_node_info(self):
        node_info_to_remove_set = set()
        all_node_info_flag = True
        self.logger.logInfo("before check_node_info, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        for disk_pool_id in self.need_check_disk_pools_id_set:
            node_info = self.get_node_info(disk_pool_id)
            self.logger.logInfo("got node_info : {} from disk pool({})".format(node_info, disk_pool_id))
            for node_info in node_info:
                if (node_info.get("errorCode") != 0):
                    node_info_to_remove_set.add(disk_pool_id)
                else:
                    all_node_info_flag = False
        self.need_check_disk_pools_id_set -= node_info_to_remove_set
        self.logger.logInfo("when check_node_info, node_info_to_remove_set : {}" \
                            .format(node_info_to_remove_set))
        self.logger.logInfo("after check_node_info, need_check_disk_pools_id_set : {}" \
                            .format(self.need_check_disk_pools_id_set))
        return all_node_info_flag

    def check_forcewb_switch(self, disk_pools_id_list):
        all_force_wb_switch_flag = True
        for disk_pool_id in disk_pools_id_list:
            disk_pools_info_parameters = self.get_disk_pools_info_parameters(disk_pool_id)
            self.logger.logInfo("got disk_pools_info_parameters : {}".format(disk_pools_info_parameters))
            for parameter in disk_pools_info_parameters:
                if (parameter.get("paraName") != "p_osd_force_wb_switch"):
                    continue
                elif (parameter.get("value") == "open"):
                    continue
                else:
                    all_force_wb_switch_flag = False
                    self.need_check_disk_pools_id_set.add(disk_pool_id)
        self.logger.logInfo("need_check_disk_pools_id_set: {}".format(self.need_check_disk_pools_id_set.add))
        return all_force_wb_switch_flag

    def check_storage_cache_rate(self):
        abnormal_pool_id_set = set()
        all_force_wb_flag = True
        for node_ip in self.all_storage_nodes:
            cmd_str = "{}/api/v2/data_service/diskpool?nodeMgrIp={}".format(self.base_uri, node_ip)
            diskpools_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
            disk_pools = diskpools_json.get("diskPools", [])
            for disk_pool in disk_pools:
                all_force_wb_flag, abnormal_pool_id_set =\
                    self.judge_storage_cache_rate(disk_pool, all_force_wb_flag, abnormal_pool_id_set)

        if (all_force_wb_flag):
            self.logger.logInfo("Passed the forcewb check.")
            self.process_result_normal()
            return common.INSPECT_PASS, "\n".join(self.ret_list), ""
        else:
            self.logger.logWarning("check disk forcewb finished. Recommended Optimization.")
            err_code = "check_disk_forcewb.result.not.pass"
            self.process_result_abnormal(abnormal_pool_id_set)
            return common.INSPECT_WARNING, "\n".join(self.ret_list), \
                common.get_err_msg(self.lang, err_code, ",".join(self.all_manage_nodes))

    def judge_storage_cache_rate(self, disk_pool, all_force_wb_flag, abnormal_pool_id_set):
        if (disk_pool.get("poolId") in self.need_check_disk_pools_id_set):
            storage_cache_rate = disk_pool.get("storageCacheRate")
            self.logger.logInfo("The storageCacheRate = {} from disk pool ({})." \
                                .format(float(disk_pool.get("storageCacheRate")), disk_pool.get("poolId")))
            if ((not storage_cache_rate) or float(storage_cache_rate) <= 0.03):
                pass
            else:
                all_force_wb_flag = False
                abnormal_pool_id_set.add(disk_pool.get("poolId"))
        return all_force_wb_flag, abnormal_pool_id_set

    def process_result_abnormal(self, abnormal_pool_id_set):
        msg = ''
        for node_ip in self.all_manage_nodes:
            msg = msg + common.get_err_msg(self.lang, "check_disk_forcewb_result.node.warning", \
                                           (node_ip, ','.join('%s' % id for id in abnormal_pool_id_set)))
        selected_not_manage_nodes = list(set(self.all_selected_nodes) - set(self.all_manage_nodes))
        for node_ip in selected_not_manage_nodes:
            msg = msg + common.get_err_msg(self.lang, "check_disk_forcewb_result.node.no.support", node_ip)
        self.ret_list.append(msg.encode("utf-8").decode("utf-8"))

    def get_disk_pools_json(self):
        cmd_str = "{}/api/v2/data_service/diskpool".format(self.base_uri)
        diskpools_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return diskpools_json

    def get_disk_pools_info_parameters(self, disk_pool_id):
        cmd_str = "{}/dsware/service/cluster/storagepool/queryDiskPoolParametersOperation?poolId={}"\
            .format(self.base_uri, disk_pool_id)
        disk_pools_info_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return disk_pools_info_json.get("parameter", [])

    def get_node_info(self, disk_pool_id):
        cmd_str = "{}/dsware/service/cluster/diskpool/queryNodeDiskInfo?diskPoolId={}"\
            .format(self.base_uri, disk_pool_id)
        node_info_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        return node_info_json.get("nodeInfo", [])

    def get_disk_model_json_single_node(self, node_ip):
        cmd_str = "{}/dsware/service/vsan/scanServerMedia".format(self.base_uri)
        node_ip_list = [node_ip]
        param = {
            "nodeIpList" : json.dumps(node_ip_list)
        }
        disk_model_json = CommonRestService.execute_post_request(self.rest, cmd_str, param)
        return disk_model_json