# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_dsm_scale_in_and_out"


def get_storage_software(dev_node):
    """
    :function: 获取存储软件版本
    :param version: 节点信息
    :return: 存储软件版本
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getHotPatchVersion()
    if not patch_version:
        return product_version

    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    else:
        return product_version + "." + patch_version


def check_storage_software(version):
    """
    :function: 存储软件风险配套检查
    :param version: 当前存储软件版本
    :return: True：检查通过；False:存在风险软件配套关系
    """
    black_product_ver = (
        "8.1.0", "8.1.0.SPH1", "8.1.0.SPH2", "8.1.0.SPH3", "8.1.0.SPH5")
    # 服务器BIOS风险版本与存储软件配套检查
    for black_ver in black_product_ver:
        if black_ver == version:
            return False
    return True


def execute(rest):
    dev_node = py_java_env.get("devInfo")
    try:
        """
        检查存储池是否开启DSM特性
        如果DSM特性开关未开启，则检查通过，否则继续执行
        """
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/resource/queryStoragePool".format(base_uri)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        if not pools_json.get("storagePools"):
            return common.INSPECT_PASS, "\n".join(pools_json), ""

        storage_pools = pools_json.get("storagePools", [])
        dsm_switch = storage_pools[0].get("dsmSwitch")
        LOGGER.logInfo("dsm_switch is:{}.".format(dsm_switch))
        if dsm_switch != 1:
            return common.INSPECT_PASS, "dsm_switch = {}".format(
                dsm_switch), ""  # 没有开启DSM开关，无风险

        """
        检查风险存储软件版本号
        如果不在风险版本范围内，则检查通过，否则继续执行
        """
        product_version = get_storage_software(dev_node)
        LOGGER.logInfo("product_version is:{}.".format(product_version))
        software_result = check_storage_software(product_version)
        if software_result:
            return common.INSPECT_PASS, "product_version = {}".format(
                product_version), ""  # 软件版本不在风险版本列表内，没有风险

        return check_is_scale_in(product_version, dev_node, rest)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_is_scale_in(product_version, dev_node, rest):
    """
    查询是否做过缩容操作
    """
    scale_ret = False
    base_uri = RestUtil.getDstorageUrlHead(dev_node)
    cmd_str = "{}/api/v2/common/events?filter=type::0".format(base_uri)
    event_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    if not event_json.get("data"):
        return common.INSPECT_PASS, "\n".join(event_json), ""
    
    data_set = event_json.get("data", [])
    for data in data_set:
        event_id = data.get("alarm_id")
        if event_id == '0xF120B0108':
            scale_ret = True

    if scale_ret:
        return common.INSPECT_UNNORMAL, "\n" + "productVersion:{}".format(product_version), common.get_err_msg(
            LANG, "check.result.dsm.scale.in", product_version),  # 做过缩容操作，有风险
    else:
        return common.INSPECT_PASS, "\n" + "check pass! productVersion:{}".format(product_version), ""  # 未做过缩容，没有风险

