# coding: UTF-8
import re
 
import common
from com.huawei.ism.exception import IsmException
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from ds_rest_util import CommonRestService
 
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
HANDLE = py_java_env.get("preInspectHandle")
ITEM_ID = "check_general_compress"


def get_storage_software(dev_node, rest):
    """
    :param dev_node: 节点信息
    :function: 获取存储软件版本
    :return: 存储软件版本
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getDistributedHotPatchVersion()
    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    elif not patch_version:
        return product_version
    else:
        return product_version + "." + patch_version


def check_version(version):
    """
    :function: 检查版本
    :param: 版本信息, 补丁信息(mutable)
    :return: True:版本涉及, False:版本不涉及
    """
    s_len = len(version)
    product_version = []
    hotpatch_version = []
    if s_len < 5:
        return False
    elif s_len < 12:
        product_version = version[0:5]
    else:
        product_version = version[0:5]
        hotpatch_version = version[6:12]
    LOGGER.logInfo("check patch version {},patch {}.".format(product_version, hotpatch_version))
    if ("8.2.0L" in version):
        return False
    if ("8.2.0" in version):
        if (hotpatch_version < "SPH010"):
            return True
    elif ("8.1.5" in version):
        if (hotpatch_version < "SPH036"):
            return True
    return False


def check_general_compress(dev_node, product_version, rest):
    """
    :function: 检查通用压缩
    :param product_version:
    :param dev_node:
    :param rest
    :return: 检查结果
    """
    uri = RestUtil.getDstorageUrlHead(dev_node)
    # 获取设备esn号
    cmd_str = "{}/api/v2/common/esn".format(uri)
    esn_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    esn = esn_json.get('data').get('esn')
    # 获取设备license
    cmd_str = "{}/deviceManager/rest/{}/license/activelicense".format(uri, esn)
    license_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    data = license_json.get('data').get('LicenseResource')
    for para in data:
        if para.get('FeatureName') == "standard SmartCompression":
            LOGGER.logInfo("dev has general license.")
            return common.INSPECT_UNNORMAL, "CHECK NOT PASS!  ", ""
    return common.INSPECT_PASS, "CHECK PASS!  ", ""


def execute(rest):
    """
    检查通用压缩
    :param rest:
    :return:
    """
 
    dev_node = py_java_env.get("devInfo")
    try:
        product_version = get_storage_software(dev_node, rest)
        is_need_check_version = check_version(product_version)
        LOGGER.logInfo("get product version {} is need check {}.".format(product_version, is_need_check_version))
        if not is_need_check_version:
            return common.INSPECT_NOSUPPORT, "\npass! version not involved, version: {}.".format(product_version), ""
        return check_general_compress(dev_node, product_version, rest)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, "", common.get_err_msg(LANG, "query.result.abnormal")