#!/usr/bin/env python
# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import re
import json
import common
from com.huawei.ism.exception import IsmException
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_iam_status_is_risk"
ALL_FAIL_IP_LIST = []


def execute(rest):
    """
    检查IMA安全启动版本是否有风险
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("check_iam_status_is_risk begin ...")
        source_info = py_java_env.get("sourceInfo")
        dev_version = py_java_env.get("version")
        LOGGER.logInfo("source_info:" + source_info)
        LOGGER.logInfo("dev_version:" + dev_version)
        if is_check_pass(source_info):
            LOGGER.logInfo("all node check pass")
            return common.INSPECT_PASS, source_info, ""
        if is_risk_product_version(dev_version):
            LOGGER.logInfo(dev_version + "is risk ver")
            get_fail_ips(source_info)
            LOGGER.logInfo("all not pass ips is:" + ",".join(ALL_FAIL_IP_LIST))
            err_code = "check_iam_status_is_risk.result.not.pass"
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, err_code, ",".join(ALL_FAIL_IP_LIST))
        source_info = source_info.replace("存在风险。", "正常")
        source_info = source_info.replace("There are risks.", "Normal")
        return common.INSPECT_PASS, source_info, ""
    except (IsmException, Exception) as exception:
        LOGGER.logError("check_iam_status_is_risk exception...")
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG,
                                                                      "check_iam_status_is_risk.result.not.pass")


def get_fail_ips(source_info):
    global ALL_FAIL_IP_LIST
    separator = "："
    if "There are risks" in source_info:
        separator = ":"
    for line in source_info.splitlines():
        if "节点" in line or "Node" in line:
            ALL_FAIL_IP_LIST.append(line.split(separator)[1])
            continue
        if "存在风险" not in line and "There are risks" not in line:
            ALL_FAIL_IP_LIST.pop()


def is_check_pass(source_info):
    if "存在风险" in source_info or "There are risks" in source_info:
        return False
    return True


def is_risk_product_version(product_version):
    """
    检查版本信息：为"8.2.0.SPH005", "8.2.0.SPH010", "8.2.0.SPH021", "8.2.0.SPH022", "8.2.0.SPH023", "8.2.0.SPH026"
    """
    risk_product_ver = (
        "8.2.0.SPH005", "8.2.0.SPH010", "8.2.0.SPH021", "8.2.0.SPH022", "8.2.0.SPH023", "8.2.0.SPH026",
    )
    for risk_ver in risk_product_ver:
        if risk_ver in product_version:
            return True
    return False
