# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException



LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkDusSwitch"


def execute(rest):
    """
    检查index dus switch状态
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("checkDusSwitch begin ...")
        source_info = py_java_env.get("sourceInfo")
        ret = is_check_pass(source_info)
        if ret == 0:
            return common.INSPECT_PASS, source_info, ""
        elif ret == 1: # 可以关闭重删压缩
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, "checkDusSwitch.result.not.pass1")
        else: # 不能关闭重删压缩需要升级
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, "checkDusSwitch.result.not.pass2")
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG, "checkDusSwitch.result.not.pass")



def is_check_pass(source_info):
    if "VOL_ON" in source_info or "DEDU_ON" in source_info:
        if "can_shut" in source_info:
            return 1
        else:
            return 2
    return 0
