# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException



LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkWriteSame"


def execute(rest):
    """
    检查index write same状态
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("checkWriteSame begin ...")
        source_info = py_java_env.get("sourceInfo")
        if is_check_pass(source_info):
            return common.INSPECT_PASS, source_info, ""
        return common.INSPECT_WARNING, source_info, common.get_err_msg(LANG, "checkWriteSame.result.not.pass")
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG, "checkWriteSame.result.not.pass")



def is_check_pass(source_info):
    if "VERSION" in source_info and "VOLUME" in source_info:
        return False
    return True
