# coding: UTF-8
import json
import common
from com.huawei.ism.exception import IsmException
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_msi_irq"


def execute(rest):
    """
    检查io设备中断版本
    :param rest: 集群检查结果
    :return:检查结果
    """
    try:
        LOGGER.logInfo("check_msi_irq begin ...")
        source_info = py_java_env.get("sourceInfo")
        dev_version = py_java_env.get("version")
        LOGGER.logInfo("dev_version:" + dev_version)
        new_source_info = source_info
        # if upgrade target version is 8.0.1.SPH623/628, need to replace substrings
        if is_involve_product_version(dev_version):
            new_source_info = source_info.replace("不涉及，NORPM", "异常：当前节点中断rpm包不符合预期， NORPM")
            new_source_info = new_source_info.replace("Not supported, NORPM",
                "Abnormal: The interruption RPM package of the current node is not as expected, NORPM")
        # if get fail information, no matter what upgrade target version is, need report abnormal
        if not is_check_pass(new_source_info):
            err_code = "check_msi_irq.result.not.pass"
            return common.INSPECT_UNNORMAL, new_source_info, common.get_err_msg(LANG, err_code)
        # if target version is not 8.0.1.SPH623/628, no risks
        if not is_involve_product_version(dev_version):
            return common.INSPECT_PASS, new_source_info, ""
        elif is_no_rpm(new_source_info):
            err_code = "check_msi_irq.result.not.pass"
            return common.INSPECT_UNNORMAL, new_source_info, common.get_err_msg(LANG, err_code)
        return common.INSPECT_PASS, new_source_info, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG,
                                                                      "check_msi_irq.result.not.pass")


def is_no_rpm(source_info):
    return "NORPM" in source_info


def is_check_pass(source_info):
    return "FAIL" not in source_info


def is_involve_product_version(product_version):
    """
    检查版本信息：目标版本非810、811版本时巡检通过
    检查版本信息：目标版本非801SPH623、801SPH628版本时巡检通过
    """
    white_product_ver = (
        "8.0.1.SPH623", "8.0.1.SPH628", 
    )
    # 非风险版本与存储软件配套检查
    for white_ver in white_product_ver:
        if white_ver in product_version:
            return True
    return False
