# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException



LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_nfsv41_status"


def execute(rest):
    """
    检查nfs41服务业务状态
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("check_nfsv41_status begin ...")
        source_info = py_java_env.get("sourceInfo")
        if is_check_pass(source_info):
            return common.INSPECT_PASS, source_info, ""
        dev_version = py_java_env.get("version")
        if is_involve_product_version(dev_version):
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, "nfsv41_check.result.not.pass")
        return common.INSPECT_PASS, source_info, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG, "nfsv41_check.result.not.pass")



def is_check_pass(source_info):
    if "异常" in source_info or "Abnormal" in source_info:
        return False
    return True


def is_involve_product_version(product_version):
    """
    检查版本信息：目标版本非812spc100版本时巡检通过
    """
    version = product_version.replace('.', "")
    if "812SPC100" in version or "812SPH1" in version:
        return True
    return False
