# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
import json

from com.huawei.ism.exception import IsmException

import cli_util
import common
import hardware_util
import redfish_util
import entity

ITEM_ID = "check_nic_version"
LANG = common.getLang(py_java_env)
HANDLE = py_java_env.get("preInspectHandle")
NORMALIZED_DRIVER_KEYS = ["pacific", "x86", "arm"]
RES_KEY = "1822_mlnx_normalized_driver_ver"
CMD_INVALID_KEYS = ("command not found", "No such file or directory",
                    "COMMAND NOT SUPPORTED")


def execute(rest_conn):
    """
    检查网卡版本
    :param rest_conn: 集群rest连接
    :return:
    """
    item = common.ItemEntity(py_java_env, ITEM_ID, PY_LOGGER, __file__)
    item.update_progress(1)
    try:
        check_nic_version(item.build_param_dict(), None, item.err_info_list, item.ret_list)
        return item.get_check_result()
    except (IsmException, Exception) as exception:
        item.logger.logException(exception)
        return item.get_failed_result(
            common.get_err_msg(LANG, "query.result.abnormal"))


@common.check_all_ibmc_node
def check_nic_version(param_dict, cluster_dev_node, err_info_list, ret_list):
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    redfish = common.get_redfish_conn(cluster_dev_node)
    ret_by_node = []
    logger = param_dict.get("logger")
    context = param_dict.get("env")
    try:
        ret = HANDLE.getTargetCheckResult(cluster_node_ip, ITEM_ID)
        logger.logInfo("FusionStorage origin: {}".format(ret))
        data = json.loads(ret)
        ret_by_node.append(data.get("original_info"))
        version_ret = data.get("result")
        uid, _ = redfish_util.get_product_unique_id(redfish, logger)
        mapping_version = hardware_util \
            .get_mapping_fw_version(context, uid, RES_KEY)
        logger.logInfo("FusionStorage nic Version: {}".format(version_ret))
        for invalid_key in CMD_INVALID_KEYS:
            if invalid_key in version_ret:
                msg = common.get_err_msg(LANG, "version.mapping.not.pass",
                                         (cluster_node_ip, version_ret, mapping_version))
                err_info_list.append(msg)
                return
        uid, _ = redfish_util.get_product_unique_id(redfish, logger)
        mapping_version = hardware_util \
            .get_mapping_fw_version(context, uid, RES_KEY)
        if not contain_normalized_driver_key(version_ret) \
                or entity.Compare.compare_digital_version(
            trans_normalized_driver_version_2_digital_version(
                version_ret),
            trans_normalized_driver_version_2_digital_version(
                mapping_version)) < 0:
            msg = common.get_err_msg(LANG, "version.mapping.not.pass",
                                     (cluster_node_ip, version_ret, mapping_version))
            err_info_list.append(msg)
    except Exception as exception:
        logger.logException(exception)
        err_info_list.append(common.get_err_msg(
            LANG, "item.check.abnormal", cluster_node_ip))
    finally:
        ret_list.append(cli_util.get_format_header_ret(
            cluster_node_ip, "\n".join(ret_by_node)))


def trans_normalized_driver_version_2_digital_version(driver_version):
    # 4.19-26-pacific-47f-0
    # 归一驱动中带有字符pacific、arm和x86，需要替换掉再进行判断
    for driver_key in NORMALIZED_DRIVER_KEYS:
        replace_version = driver_version.strip().replace(driver_key, "0")
    # 倒数第二位为16进制需要转换成10进制
    versions = replace_version.split("-")
    versions[-2] = str(int(versions[-2], 16))
    return "-".join(versions)


def contain_normalized_driver_key(ver_info):
    return bool([driver_key for driver_key in NORMALIZED_DRIVER_KEYS if driver_key in ver_info])
