# coding:utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_numa_consistent"
# 保存检查结果为不通过的结果信息
err_msg = []


def execute(rest):
    """
    检查集群内各存储池节点的Numa开关一致性
    :param rest: 集群rest连接
    :return:检查结果
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    try:
        # 判断是否是涉及版本 仅821及之后版本涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        LOGGER.logInfo("product_version:%s" % str(product_version))
        if not is_involved_version(product_version):
            LOGGER.logInfo("product version({}) is not involved.".format(product_version))
            return common.INSPECT_NOSUPPORT, "", ""

        LOGGER.logInfo("check numa consistent begin ...")
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/cluster/queryNumaConsistent".format(
            base_uri
        )
        ret_list.append(cmd_str)
        cluster_numa_info_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(cluster_numa_info_json))
        LOGGER.logInfo(cluster_numa_info_json)
        cluster_numa_info = cluster_numa_info_json.get("data")
        LOGGER.logInfo("cluster numa info:%s" % str(cluster_numa_info))
        is_cluster_support_numa = cluster_numa_info.get("isClusterSupportNuma")
        if not is_cluster_support_numa:
            LOGGER.logInfo("No nodes enable Numa.")
            return common.INSPECT_NOSUPPORT, "", ""
        is_cluster_numa_switch_consistent = cluster_numa_info.get("isClusterNumaSwitchConsistent")
        LOGGER.logInfo("is_cluster_numa_switch_consistent:%s" % str(is_cluster_numa_switch_consistent))
        if is_cluster_numa_switch_consistent:
            LOGGER.logInfo("check numa consistent success, inspection end.")
            return common.INSPECT_PASS, "\n".join(ret_list), ""
        else:
            deal_failed_scene(cluster_numa_info)
        if err_msg:
            LOGGER.logInfo("check numa consistent failed, inspection end.")
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), "\n".join(err_msg)
        LOGGER.logInfo("check numa consistent success, inspection end.")
        return common.INSPECT_PASS, "\n".join(ret_list), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def deal_failed_scene(cluster_numa_info):
    storage_pool_infos = cluster_numa_info.get("nodeNumaSwitchList")
    LOGGER.logInfo(storage_pool_infos)
    for storage_pool_info in storage_pool_infos:
        is_pool_numa_switch_consistent = storage_pool_info.get("isPoolNumaSwitchConsistent")
        LOGGER.logInfo(is_pool_numa_switch_consistent)
        if not is_pool_numa_switch_consistent:
            err_msg.append(common.get_err_msg(LANG, "check.cluster.numa.consistent.not.pass")
                           .format(storage_pool_info.get("storagePoolId")))
    LOGGER.logInfo("err_msg: %s" % str(err_msg))


def is_involved_version(product_version):
    """
    检查版本信息:821及之后版本支持该巡检项 820版本不支持 820之前版本不展示该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:3] == "820":
        return False
    return True
