# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from cbb.frame.base import jsonUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_default_password"


def execute(rest):
    """
    检查存储系统帐号是否为默认密码
    :param env:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/aa/default_password_check?NAME=admin".format(
            base_uri
        )

        ret_list.append(cmd_str)
        response = rest.execGetNotCheckResp(cmd_str, None, None, None)
        status_code = response.getStatusLine().getStatusCode()
        if status_code == 404:
            ret_list.append("http status:404")
            return (
                common.INSPECT_NOSUPPORT,
                "\n".join(ret_list), ""
            )
        err_code = response.getContentMap().get("errorCode")
        if err_code is None or (str(err_code) == "0"):
            response_json = jsonUtil.jsonStr2Dict(str(response.getContent()))
        else:
            description = response.getContentMap().get("description")
            ret_list.append(err_code + ':' + description)
            raise IsmException(int(err_code), description)
        ret_list.append(str(response_json))
        respData = response_json.get("data")
        if len(respData) != 0:
            if respData.get("PasswdStatus") == "1":
                return common.INSPECT_PASS, "\n".join(ret_list), ""
            elif respData.get("PasswdStatus") == "0":
                return (
                    common.INSPECT_UNNORMAL,
                    "\n".join(ret_list),
                    common.get_err_msg(LANG, "default_password_check.result.not.pass", "admin")
                )
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
    return (
        common.INSPECT_UNNORMAL,
        "\n".join(ret_list),
        common.get_err_msg(LANG, "query.result.abnormal"),
    )
