# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException



LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkVDBPlogMetaKeyNumber"
ALL_FAIL_IP_LIST = []


def execute(rest):
    """
    检查pi元数据占用key个数
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("checkVDBPlogMetaKeyNumber begin ...")
        source_info = py_java_env.get("sourceInfo")
        LOGGER.logInfo("source_info:" + source_info)
        if is_check_pass(source_info):
            return common.INSPECT_PASS, source_info, ""
        dev_version = py_java_env.get("version")
        LOGGER.logInfo("dev_version:" + dev_version)
        if is_skip_product_version(dev_version):
            return common.INSPECT_PASS, source_info, ""
        get_fail_ips(source_info)
        LOGGER.logInfo("all not pass ips is:" + ",".join(ALL_FAIL_IP_LIST))
        err_code = "check_pi_key_cnt.result.not.pass"
        return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, err_code, ",".join(ALL_FAIL_IP_LIST))
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG, "check_pi_key_cnt.result.not.pass")


def get_fail_ips(source_info):
    global ALL_FAIL_IP_LIST
    separator = "："
    if "Node" in source_info:
        separator = ":"
    for line in source_info.splitlines():
        if "节点" in line or "Node" in line:
            ALL_FAIL_IP_LIST.append(line.split(separator)[1])
            continue
        if "checkVDBPlogMetaKeyNumber-1" in line:
            continue
        if "normal" in line:
            ALL_FAIL_IP_LIST.pop()


def is_check_pass(source_info):
    if "18446744073708568582" in source_info or "need repair" in source_info:
        return False
    return True


def is_skip_product_version(product_version):
    """
    检查版本信息：目标版本812之前的目标版本忽略
    """
    version = product_version.replace('.', "")
    LOGGER.logInfo("rep_version:" + version)
    if "801" in version or "810" in version:
        return True
    if "811" in version:
        return True
    return False