# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_pool_redundancy_policy"


def execute(rest):
    """
    检查存储池的冗余策略,SAS主存：EC4+2,SATA主存：3副本
    :param rest: 集群rest连接
    :return:检查结果
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    LOGGER.logInfo("check_pool_redundancy_policy begin ...")
    try:
        # 812之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "", ""

        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/data_service/diskpool".format(base_uri)
        ret_list.append(cmd_str)
        disk_pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(disk_pools_json))
        LOGGER.logInfo(disk_pools_json)

        result = disk_pools_json.get("result")
        if result != 0:
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal"),

        disk_pools = disk_pools_json.get("diskPools")
        warning_pool_id_list = list()
        for disk_pool in disk_pools:
            pool_id = disk_pool.get("poolId")
            media_type = disk_pool.get("mediaType")
            replication_factor = disk_pool.get("replicationFactor")
            redundancy_policy = disk_pool.get("redundancyPolicy")
            num_data_units = disk_pool.get("numDataUnits")
            num_parity_units = disk_pool.get("numParityUnits")
            if media_type == "sata_disk" and replication_factor != 3:
                warning_pool_id_list.append(pool_id)
                continue
            flag = False
            if redundancy_policy != "ec" or num_data_units != 4 or num_parity_units != 2:
                flag = True
            if media_type == "sas_disk" and flag:
                warning_pool_id_list.append(pool_id)
        if len(warning_pool_id_list) > 0:
            warning_pool_id_list = [str(pool_id) for pool_id in warning_pool_id_list]
            LOGGER.logInfo(warning_pool_id_list)
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "check.pool.redundancy.not.pass").format(warning_pool_id_list))
        return common.INSPECT_PASS, "\n".join(ret_list), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_involve_product_version(product_version):
    """
    检查版本信息：812之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "2":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "3":
            return True
    return False