# coding: UTF-8
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_scale_in_and_out_cnt"


def check_dsm(rest, dev_node):
    """
    :function: 检查是否是dsm池环境
    :param: 集群rest链接, 节点信息
    :return: True:dsm池, False:非dsm池
    """
    uri = RestUtil.getDstorageUrlHead(dev_node)
    cmd_str = "{}/dsware/service/resource/queryStoragePool".format(uri)
    pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    if not pools_json.get("storagePools"):
        return False

    storage_pools = pools_json.get("storagePools", [])
    dsm_switch = storage_pools[0].get("dsmSwitch")
    if dsm_switch == 1:
        return True
    else:
        return False


def get_product_version(dev_node):
    """
    :function: 获取版本
    :param: 节点信息
    :return: 版本信息
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getHotPatchVersion()
    if not patch_version:
        return product_version

    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    else:
        return product_version + "." + patch_version


def check_version(version, patch_num):
    """
    :function: 检查版本
    :param: 版本信息, 补丁信息(mutable)
    :return: True:版本涉及, False:版本不涉及
    """
    s_len = len(version)
    if s_len >= 10:
        patch_s = version[9:s_len]
        patch_num[0] = int(patch_s.split(".")[0])

    if ("8.0.3" in version) or ("8.0.1.5" in version):
        return True
    elif "8.0.1" in version:
        if patch_num[0] < 606:
            return True
    elif "8.1.0" in version:
        if patch_num[0] < 3:
            return True
    else:
        return False
    
    return False


def get_scale_cnt(rest, dev_node, scale_cnt):
    """
    :function: 获取设备做扩容的次数
    :param: 集群rest链接, 节点信息, 扩缩容次数(mutable)
    :return: 无
    """
    """
    :block扩容: 0xF120B0106
    :block缩容: 0xF120B0108
    :nas扩容: 0x100100D80003, param: 2
    :nas缩容: 0x100100D80003, param: 3
    """
    uri = RestUtil.getDstorageUrlHead(dev_node)
    cmd_str = "{}/api/v2/common/events?filter".format(uri)
    event_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    if not event_json.get("data"):
        cmd_str = "{}/api/v2/common/events?range".format(uri)
        event_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        if not event_json.get("data"):
            return

    data_set = event_json.get("data", [])
    for data in data_set:
        event_id = data.get("alarm_id")
        if event_id == '0xF120B0106':
            scale_cnt[0] += 1
        elif event_id == '0xF120B0108':
            scale_cnt[1] += 1
        elif event_id == '0x100100D80003':
            param_s = data.get("alarm_params")
            param_num = int(param_s[0])
            if param_num == 2:
                scale_cnt[0] += 1
            elif param_num == 3:
                scale_cnt[1] += 1

    return


def execute(rest):
    dev_node = py_java_env.get("devInfo")

    try:
        is_dsm = check_dsm(rest, dev_node)
        if is_dsm:
            return common.INSPECT_PASS, "\npass! dsm pool not involved.", ""

        version = get_product_version(dev_node)
        patch_num = [0]
        is_version_in = check_version(version, patch_num)
        if not is_version_in:
            return common.INSPECT_PASS, "\npass! version not involved, version: {}.".format(version), ""

        scale_cnt = [0, 0]
        get_scale_cnt(rest, dev_node, scale_cnt)
        is_pass = 1
        if scale_cnt[0] + scale_cnt[1] >= 30:
            is_pass = 0
        elif scale_cnt[0] >= 20 and scale_cnt[1] >= 5:
            is_pass = 0
        elif scale_cnt[1] >= 10:
            is_pass = 0

        if is_pass == 1:
            return common.INSPECT_PASS, "\npass! scale-out cnt: {}, scale-in cnt: {}, version: {}.".format(
                scale_cnt[0], scale_cnt[1], version), ""
        else:
            return common.INSPECT_UNNORMAL, "\nnot pass, scale-out cnt: {}, scale-in cnt: {}, version: {}.".format(
                scale_cnt[0], scale_cnt[1], version), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal."),
        )
