# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_server_number_for_block"


def execute(rest):
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    LOGGER.logInfo("check_server_number_for_block begin ...")
    try:
        # 813之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "", ""

        LOGGER.logInfo("checkServerNumberForBlock is begin...")
        """
        1、块场景
        2、硬盘池安全级别为server
        3、硬盘池的节点数大于等于数据块加校验块之和，巡检通过，否则，建议优化
        4、建议扩容硬盘池，使节点数量满足ec配比。
        """
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/data_service/diskpool".format(base_uri)
        ret_list.append(cmd_str)
        disk_pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(disk_pools_json))
        LOGGER.logInfo(disk_pools_json)

        result = disk_pools_json.get("result")
        if result != 0:
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal"),

        disk_pools = disk_pools_json.get("diskPools")
        warning_pool_id_list = list()
        for disk_pool in disk_pools:
            pool_id = disk_pool.get("poolId")
            num_data_units = disk_pool.get("numDataUnits")
            num_parity_units = disk_pool.get("numParityUnits")
            redundancy_policy = disk_pool.get("redundancyPolicy")
            pool_node_num = disk_pool.get("poolNodeNum")
            security_level = disk_pool.get("securityLevel")
            service_type = disk_pool.get("serviceType")

            if service_type != 1 or redundancy_policy != "ec":
                continue
            if security_level != "server":
                continue
            if pool_node_num < num_data_units + num_parity_units:
                warning_pool_id_list.append(pool_id)

        if len(warning_pool_id_list) > 0:
            warning_pool_id_list = [str(pool_id) for pool_id in warning_pool_id_list]
            LOGGER.logInfo(warning_pool_id_list)
            return (
                common.INSPECT_WARNING,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "check.sever.num.not.pass").format(warning_pool_id_list))

        return common.INSPECT_PASS, "\n".join(ret_list), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False