# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_storage_cache_rate"


def execute(rest):
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    try:
        # 813之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "", ""

        LOGGER.logInfo("checkStorageCacheRateForBlock is begin..")
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/data_service/diskpool".format(base_uri)
        ret_list.append(cmd_str)
        disk_pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(disk_pools_json))
        LOGGER.logInfo(disk_pools_json)

        result = disk_pools_json.get("result")
        if result != 0:
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal"),

        disk_pools = disk_pools_json.get("diskPools")
        warning_pool_id_list_for_block = list()
        warning_pool_list_for_non_block = list()
        for disk_pool in disk_pools:
            pool_id = disk_pool.get("poolId")
            storage_cacherate = disk_pool.get("storageCacheRate")
            media_type = disk_pool.get("mediaType")
            service_type = disk_pool.get("serviceType")
            """
            结构，阈值0.03，小于阈值，巡检结构：不通过
            非结构化，阈值为0.0133，小于阈值，巡检结果：建议优化
            """
            if media_type == "ssd_disk" or media_type == "ssd_card":
                continue
            if service_type == 1 and float(storage_cacherate) < 0.03:
                warning_pool_id_list_for_block.append(pool_id)
            elif service_type != 1 and float(storage_cacherate) < 0.0133:
                warning_pool_list_for_non_block.append(pool_id)
        if len(warning_pool_id_list_for_block) > 0:
            warning_pool_id_list_for_block = [str(pool_id) for pool_id in warning_pool_id_list_for_block]
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "check.cache.main.rate.not.pass").format(warning_pool_id_list_for_block))
        if len(warning_pool_list_for_non_block) > 0:
            warning_pool_list_for_non_block = [str(pool_id) for pool_id in warning_pool_list_for_non_block]
            return (
                common.INSPECT_WARNING,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "check.cache.main.rate.for.warning").format(warning_pool_list_for_non_block))
        return common.INSPECT_PASS, "\n".join(ret_list), ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False