# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_storage_pool_ec_config"


def execute(rest):
    """
    检查存储池EC配比
    :param rest:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/data_service/diskpool".format(
            base_uri
        )
        ret_list.append(cmd_str)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(pools_json))
        if not pools_json.get("diskPools"):
            return common.INSPECT_PASS, "\n".join(ret_list), ""

        progress_map[ITEM_ID] = 50
        observer.updateProgress(progress_map)
        disk_pools = pools_json.get("diskPools", [])

        return handle_result(disk_pools)

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_PASS,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def handle_result(disk_pools):
    inspect_result = common.INSPECT_PASS
    ret_list = []

    tittle = "Pool Id\tRedundancy Policy\tEC Data Block Quantity\tEC Parity Block Quantity\tNumber Of Allowed Node " \
             "failures "
    ret_list.append(tittle)
    for disk_pool in disk_pools:
        info = DiskPoolInfo(disk_pool)
        ret_list.append(info.build_ret_str_info())

    return inspect_result, "\n".join(ret_list), ""


class DiskPoolInfo:
    def __init__(self, data):
        self.pool_id = str(data.get("poolId"))
        self.redundancy_policy = data.get("redundancyPolicy")
        self.num_data_units = str(data.get('numDataUnits'))
        self.num_parity_units = str(data.get("numParityUnits"))
        self.num_fault_tolerance = str(data.get("numFaultTolerance"))

    def build_ret_str_info(self):
        return '{}\t{}\t{}\t{}\t{}'.format(self.pool_id.ljust(7, ' '), self.redundancy_policy.ljust(17, ' '),
                                           self.num_data_units.ljust(22, ' '),
                                           self.num_parity_units.ljust(24, ' '),
                                           self.num_fault_tolerance)
