# coding: UTF-8
import re
 
import common
from com.huawei.ism.exception import IsmException
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from ds_rest_util import CommonRestService
 
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
HANDLE = py_java_env.get("preInspectHandle")
ITEM_ID = "check_tier_switch"


def get_storage_software(dev_node):
    """
    :param dev_node: 节点信息
    :function: 获取存储软件版本
    :return: 存储软件版本
    """
    LOGGER.logInfo("check product version.")
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getDistributedHotPatchVersion()
    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    elif not patch_version:
        return product_version
    else:
        return product_version + "." + patch_version


def check_version(version, patch_num):
    """
    :function: 检查版本
    :param: 版本信息, 补丁信息(mutable)
    :return: True:版本涉及, False:版本不涉及
    """
    if ("8.1.3" in version):
        return True
    
    return False


def check_tier_switch(dev_node, product_version, rest):
    """
    :function: 检查tier开关
    :param product_version:
    :param dev_node:
    :return: 检查结果
    """
    uri = RestUtil.getDstorageUrlHead(dev_node)
    cmd_str = "{}/dsware/service/cluster/storagepool/queryStoragePool".format(uri)
    pool_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    for para in pool_json['storagePools']:
        servertype = para.get('serviceType')
        LOGGER.logInfo("check pool {}.".format(servertype))
        if (servertype != 5): # block不涉及
            return common.INSPECT_PASS, "CHECK PASS!  ", ""
    cmd_str = "{}/api/v2/tier_service/tier_global_cfg".format(uri)
    tier_switch_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    tier_switch = tier_switch_json.get('data').get('tier_switch')
    if (tier_switch == 0):
        LOGGER.logInfo("check tier switch {}.".format(tier_switch))
        return common.INSPECT_PASS, "CHECK PASS!  ", ""
    LOGGER.logInfo("check tier switch {}.".format(tier_switch))
    return common.INSPECT_UNNORMAL, "CHECK NOT PASS!  ", ""


def execute(rest):
    """
    检查tier开关
    :param rest:
    :return:
    """
    dev_node = py_java_env.get("devInfo")
    try:
        LOGGER.logInfo("check start.")	
        product_version = get_storage_software(dev_node)
        patch_num = [0]
        is_need_check_version = check_version(product_version, patch_num)
        LOGGER.logInfo("check start product {}.".format(product_version))
        if not is_need_check_version:
            return common.INSPECT_NOSUPPORT, "\npass! version not involved, version: {}.".format(product_version), ""
        return check_tier_switch(dev_node, product_version, rest)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, "", common.get_err_msg(LANG, "query.result.abnormal")