#!/usr/bin/env python
# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

import re
import ast
from com.huawei.ism.exception import IsmException
import common
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
HANDLE = py_java_env.get("preInspectHandle")
ITEM_ID = "check_uce_is_normal"
PRE_ITEM_ID = "pre_inspect_get_euler_version"
not_pass_node_info = []


def get_version_num(pattern, version_string):
    version = re.search(pattern, version_string)
    return int(version.group(1)) if version else 0


def get_euler_version(node_ip):
    fail_string = "fail"
    try:
        # 获得预巡检结果欧拉版本
        pre_info = HANDLE.getPreInspectResultWithLinePython(node_ip, PRE_ITEM_ID)
        LOGGER.logInfo("Checking uce is normal pre-info is {}.".format(str(pre_info)))
        euler_version, battery_memory, is_fix_notify = ast.literal_eval(pre_info)["result"].splitlines()
        LOGGER.logInfo("node {}, version {}, is_fix_notify {} battery_memory {}".
                       format(node_ip, euler_version, is_fix_notify, battery_memory))
        return euler_version, is_fix_notify, battery_memory
    except (IsmException, Exception) as e:
        LOGGER.logException(e)
        not_pass_node_info.append("node {} faild to get EulerOS version ".format(node_ip))
        return fail_string, fail_string, fail_string


def is_check_node(node):
    node_ip = common.get_node_ip(node)
    LOGGER.logInfo("Node ip is {}.".format(node_ip))
    # 未勾选的节点跳过
    if not node.isSelected():
        LOGGER.logInfo("Node {} is not selected, ignore.".format(node_ip))
        return False
    # 非存储节点跳过
    if not node.isStorageNode():
        LOGGER.logInfo("Node {} is not storage node, ignore.".format(node_ip))
        return False
    return True


def execute(rest):
    dev_node = py_java_env.get("devInfo")
    # 获取设备集群节点信息
    nodes = dev_node.getClusterNodes()
    LOGGER.logInfo("Checking uce is normal start")
    is_version_815 = False
    is_version_820 = False
    #8.2.0
    product_version = dev_node.getProductVersion()
    #8.2.0.SPH026
    patch_version = dev_node.getDistributedHotPatchVersion()
    if len(patch_version) == 0:
        patch_version = "--"
    try:
        product_info = "product_version:{}, patch_version:{}".format(product_version, patch_version)
        LOGGER.logInfo(product_info)
        is_version_820 = True if re.match("8.2.0", product_version) else False
        is_version_815 = True if re.match("8.1.5", product_version) else False
        if not is_version_820 and not is_version_815:
            return common.INSPECT_PASS, "", ""

        for node in nodes:
            if not is_check_node(node):
                continue
            node_ip = common.get_node_ip(node)
            # 获得预巡检结果
            euler_version, is_fix_notify, battery_memory = get_euler_version(node_ip)
            # 获取信息失败或者不存在保电内存，跳过此节点
            if euler_version == "fail" or battery_memory == "not_exist":
                continue
            euler_version_num = get_version_num("eulerosv2r(\d+)", euler_version)
            if euler_version_num != 11:
                continue
            # 如果欧拉版本为11，并且rpm -qa | grep fixnotify查询出已打补丁，则通过
            if is_fix_notify != "not_fix":
                LOGGER.logInfo("Node {} is fix_notify".format(node_ip))
                continue
            not_pass_node_info.append("node ip: {}, EulerOS version: {}, patch version: {}".
                                        format(node_ip, euler_version, patch_version))
        if not_pass_node_info:
            return common.INSPECT_UNNORMAL, "\n".join(not_pass_node_info), \
                   common.get_err_msg(LANG, "check.uce.normal")
        return common.INSPECT_PASS, product_info, ""

    except (IsmException, Exception) as e:
        LOGGER.logException(e)
        LOGGER.logError("Checking uce is normal Exception.")
        return (common.INSPECT_UNNORMAL, "Checking uce is normal Exception.",
                common.get_err_msg(LANG, "query.result.abnormal"))