# coding: UTF-8

import re
import string
import common
from com.huawei.ism.exception import IsmException

LANG = common.getLang(py_java_env)
PY_JAVA_ENV = py_java_env
HANDLE = py_java_env.get("preInspectHandle")
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_upgrade_path"
PRE_ITEM_ID = "checkUpgradePath"


def execute(rest):
    dev_node = py_java_env.get("devInfo")
    try:
        LOGGER.logInfo("checkUpgradePath is begin...")
        ret = common.INSPECT_PASS
        err_msg = ""
        dev_nodes = dev_node.getClusterNodes()
        for cluster_node in dev_nodes:
            if "management" not in cluster_node.getRoles():
                continue
            node_ip = common.get_node_ip(cluster_node)
            LOGGER.logInfo("node ip is {}".format(node_ip))
            upgrade_info = HANDLE.getPreInspectResultWithLine(node_ip, PRE_ITEM_ID)
            LOGGER.logInfo("upgrade info is:{}.".format(upgrade_info))
            if "empty" in upgrade_info:
                upgrade_info = "NA"
            elif "error" in upgrade_info:
                ret = common.INSPECT_UNNORMAL
                upgrade_info = "ABNORMAL"
                err_msg = common.get_err_msg(LANG, "query.result.abnormal")
            return (
                ret,
                upgrade_info,
                err_msg,
            )
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )

