# coding: UTF-8
import os
import common
try:
    import configparser
except ImportError:
    import ConfigParser as configparser

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
STORAGE_CONFIG_FILE_NAME = "storage_account_default_value.properties"


def execute(rest):
    """
    检查存储系统帐号是否为默认密码
    :param env:
    :return:
    """
    dev_node = py_java_env.get("devInfo")
    try:
        config = configparser.ConfigParser()
        config.read(os.path.join(BASE_DIR, STORAGE_CONFIG_FILE_NAME))
        default_value = config.get("storage", "storage_default_account_value").split(',')
        user_name = dev_node.getLoginUser().getUserName()
        pwd = dev_node.getLoginUser().getPassword()
        if user_name != 'admin' :
            return (
                common.INSPECT_WARNING,
                'result:optimization recommended',
                common.get_err_msg(LANG, "default_password_check.result.warning", "admin")
            )
        if user_name == 'admin' and pwd in default_value:
            return (
                common.INSPECT_UNNORMAL,
                'result:not pass',
                common.get_err_msg(LANG, "default_password_check.result.not.pass", "admin")
            )  
        else :
            return common.INSPECT_PASS, 'result:pass', ""
    except (Exception) as exception:
        LOGGER.logException(exception)
    return (
        common.INSPECT_UNNORMAL,
        'result:abnormal',
        common.get_err_msg(LANG, "query.result.abnormal"),
    )
