# coding: UTF-8
import re
import string

import common
from com.huawei.ism.exception import IsmException


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_zk_log_overlimit"


def get_storage_software(dev_node):
    """
    :function: 获取存储软件版本
    :param version: 节点信息
    :return: 存储软件版本
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getDistributedHotPatchVersion()

    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    elif not patch_version:
        return product_version
    else:
        return product_version + "." + patch_version


def check_storage_software(version):
    """
    :function: 存储软件风险配套检查
    :param version: 当前存储软件版本
    :return: True：检查通过；False:检查不通过
    """
    black_product_ver = (
        "8.1.5", "8.1.5.SPH001", "8.1.5.SPH005", "8.1.5.SPH010",
    )
    # 非风险版本与存储软件配套检查
    return version not in black_product_ver


def execute(rest):
    """
    检查ZK日志是否有超限风险
    :param env:
    :return:
    """
    dev_node = py_java_env.get("devInfo")
    try:
        product_version = get_storage_software(dev_node)
        software_result = check_storage_software(product_version)
        if software_result:
            return common.INSPECT_PASS, "CHECK PASS ! product_version = {}".format(
                product_version), ""  # 软件版本不在风险版本列表内，没有风险
        else:
            return common.INSPECT_UNNORMAL, "CHECK FAIL! product_version = {}".format(
                product_version), ""  # 软件版本在风险版本列表内，存在风险
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, "", common.get_err_msg(LANG, "query.result.abnormal"),
        )
