# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_zk_node"


def execute(rest):
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    try:
        # 813之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "", ""
        """
        存储节点数低于5节点，不检查zk节点数
        """
        LOGGER.logInfo("checkZkNode is begin...")
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/server/queryAllHost".format(base_uri)
        ret_list.append(cmd_str)
        host_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(host_json))
        host_num = len(host_json.get("hostInfoList"))
        LOGGER.logInfo("host number is:{}.".format(host_num))

        cmd_str = "{}/dsware/service/cluster/queryManageCluster".format(base_uri)
        manager_cluster_info_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(cmd_str)
        ret_list.append(str(manager_cluster_info_json))

        zk_node_num = len(manager_cluster_info_json.get("nodeInfo"))
        LOGGER.logInfo("hostNum is:{}, zkNodeNum is:{}.".format(host_num, zk_node_num))
        if host_num < 5:
            return common.INSPECT_WARNING, "\n".join(ret_list),  common.get_err_msg(LANG, "check.node.number.failed")
        elif 5 <= host_num < 128:
            if zk_node_num < 5:
                return common.INSPECT_WARNING, "\n".join(ret_list), common.get_err_msg(LANG, "check.zk.number.failed")
            else:
                return common.INSPECT_PASS, "\n".join(ret_list), ""
        else:
            if zk_node_num < 7:
                return common.INSPECT_WARNING, "\n".join(ret_list), common.get_err_msg(LANG, "check.zk.number.failed")
            else:
                return common.INSPECT_PASS, "\n".join(ret_list), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False
