# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "check_zk_type"
EXECUTION_RECORDS = []

"""
检查标准：
1、若zkType为dir或partition，巡检结果为不通过；
2、若zkType为sys_disk，服务器为私有硬件，巡检结果为通过；
3、若zkType为sys_disk，服务器为通用服务器，巡检结果为建议优化；
4、若zkType为SSD，包含ssd_card、ssd_disk、m2_disk, 巡检结果为通过；
5、若zkType为sata_disk，只有基础业务时，硬盘池个数小于等于8，巡检结果为通过；
6、若zkType为sata_disk，只有基础业务时，硬盘池个数在（8,16】区间，巡检结果为建议优化；
7、若zkType为sata_disk，只有基础业务时，硬盘池个数大于16，巡检结果为建议优化；
8、若zkType为sata_disk，带复制业务时，硬盘池个数小于等于8，巡检结果为建议优化；
9、若zkType为sata_disk，带复制业务时，硬盘池个数大于8，巡检结果为建议优化；
10、若zkType为sas_disk，只有基础业务时，硬盘池个数小于等于16，巡检结果为通过；
11、若zkType为sas_disk，只有基础业务时，硬盘池个数大于16，巡检结果为建议优化；
12、若zkType为sas_disk，带复制业务时，硬盘池个数小于等于8，巡检结果为通过；
13、若zkType为sas_disk，带复制业务时，硬盘池个数大于8，巡检结果为建议优化。
"""


def execute(rest):
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    try:
        # 813之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "", ""

        LOGGER.logInfo("checkZktype is begin...")
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/cluster/queryManageCluster".format(base_uri)
        manage_cluster_info = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(cmd_str)
        ret_list.append(str(manage_cluster_info))

        LOGGER.logInfo(manage_cluster_info)
        zk_type = manage_cluster_info.get("nodeInfo")[0].get("diskInfo").get("diskType")
        zk_server_id = manage_cluster_info.get("nodeInfo")[0].get("nodeId")
        LOGGER.logInfo("zkType:{}".format(zk_type))

        if zk_type == "dir" or zk_type == "partition":
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "check.zk.type.failed")
        elif zk_type == "sys_disk":
            if is_proprietary_hardware_environment(rest, base_uri, zk_server_id, ret_list):
                return common.INSPECT_PASS, "\n".join(ret_list), ""
            else:
                return common.INSPECT_WARNING, "\n".join(ret_list), \
                       common.get_err_msg(LANG, "check.zk.type.failed.for.sys.disk")
        elif zk_type == "ssd_card" or zk_type == "ssd_disk" or zk_type == "m2_disk":
            return common.INSPECT_PASS, "\n".join(ret_list), ""
        elif zk_type == "sata_disk":
            if check_when_zk_type_is_sata_disk(rest, base_uri, ret_list):
                return common.INSPECT_PASS, "\n".join(ret_list), ""
            else:
                return (
                    common.INSPECT_WARNING,
                    "\n".join(ret_list),
                    common.get_err_msg(LANG, "check.zk.type.for.warning"))
        elif zk_type == "sas_disk":
            if check_when_zk_type_is_sas_disk(rest, base_uri, ret_list):
                return common.INSPECT_PASS, "\n".join(ret_list), ""
            else:
                return common.INSPECT_WARNING, "\n".join(ret_list), \
                       common.get_err_msg(LANG, "check.zk.type.for.warning")
        else:
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_proprietary_hardware_environment(rest, base_uri, zk_server_id, ret_list):
    cmd_str = "{}/api/v2/cluster/servers/{}".format(base_uri, zk_server_id)
    server_info = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    ret_list.append(cmd_str)
    ret_list.append(str(server_info))

    base_board = server_info.get("data").get("base_board")
    LOGGER.logInfo("baseBoard is : {}".format(base_board))
    proprietary_hardware = ['STL6SPCM', 'STL6SPCN', 'STL6SPCO', 'STL6SPCX', 'STL6SPCY']
    for item in proprietary_hardware:
        if base_board == item:
            return True
    return False


def check_when_zk_type_is_sata_disk(rest, base_uri, ret_list):
    cmd_ctr = "{}/api/v2/data_service/diskpool".format(base_uri)
    disk_infos = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_ctr)
    ret_list.append(cmd_ctr)
    ret_list.append(str(disk_infos))
    disk_number = len(disk_infos.get("diskPools"))
    LOGGER.logInfo("disk number is : {}".format(disk_number))

    if does_cluster_exist(base_uri, rest, ret_list):
        return False
    else:
        if disk_number <= 8:
            return True
        else:
            return False


def check_when_zk_type_is_sas_disk(rest, base_uri, ret_list):
    cmd_ctr = "{}/api/v2/data_service/diskpool".format(base_uri)
    disk_infos = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_ctr)
    ret_list.append(cmd_ctr)
    ret_list.append(str(disk_infos))

    disk_number = len(disk_infos.get("diskPools"))
    LOGGER.logInfo("disk number is : {}".format(disk_number))

    if does_cluster_exist(base_uri, rest, ret_list):
        if disk_number <= 8:
            return True
        else:
            return False
    else:
        if disk_number <= 16:
            return True
        else:
            return False


def get_cluster_json(base_uri, rest, ret_list):
    """
    批量查询复制集群信息
    :param base_uri: str
    :param rest: class
    :return: tuple
    """
    cmd_str = "{}/dsware/service/serviceCmd".format(base_uri)
    client_data = {
        "op": "drCmd",
        "serviceType": "dr",
        "subOp": "queryControlCluster",
    }
    pools_json = CommonRestService.execute_post_request(rest, cmd_str, client_data)
    ret_list.append(cmd_str)
    ret_list.append(str(pools_json))
    ret_tuple = (cmd_str, str(pools_json))
    return pools_json, ret_tuple,


def does_cluster_exist(base_uri, rest, rest_list):

    global EXECUTION_RECORDS
    # 获取复制集群ID
    pools_json, ret_tuple = get_cluster_json(base_uri, rest, rest_list)
    EXECUTION_RECORDS.extend(ret_tuple)
    if not pools_json.get('serviceCmdData'):
        # 没有复制集群
        return False
    return True


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False

