# coding:utf-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkedssubhealthswitchstatus"


def execute(rest):
    """
    检查EDS亚健康开关状态
    :param env:
    :return:
    """
    LOGGER.logInfo('checkedssubhealthswitchstatus start')
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        #刷新进度
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        #查询开关信息
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/api/v2/data_service/subhealth_switch".format(
            base_uri
        )
        LOGGER.logInfo('exec_get_gor_big_by_ds start, cmd_str:%s', cmd_str)
        switch_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        switch_json_str = str(switch_json)
        LOGGER.logInfo('exec_get_gor_big_by_ds end, cmd_str:%s , switch_json:%s', cmd_str, switch_json_str)
        if switch_json.get("result") != 0:
            ret_list.append("error, please contact technical support engineers!result_code:")
            ret_list.append(switch_json.get("result"))
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), ""
        # 刷新进度
        progress_map[ITEM_ID] = 80
        observer.updateProgress(progress_map)
        # 开关状态判断
        subhealth_switch = switch_json.get("subhealth_switch", "")
        ret_list.append("subhealth_switch:")
        if subhealth_switch == '0':
            # 亚健康开关没有打开则1-巡检不通过
            result = common.INSPECT_UNNORMAL
            ret_list.append(subhealth_switch)
        elif subhealth_switch == '1':
            # 亚健康开关打开则0-巡检通过
            result = common.INSPECT_PASS
            ret_list.append(subhealth_switch)
        else:
            # 不存在，则表示eds集群不存在，返回3不涉及
            result = common.INSPECT_NOSUPPORT
            ret_list.append("N/A")
        LOGGER.logInfo('checkedssubhealthswitchstatus end, result:%s', result)
        return result, "".join(ret_list), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )