# coding: UTF-8

import common
from ds_rest_util import CommonRestService
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil

ENV = py_java_env
LANG = common.getLang(py_java_env)


def execute(rest):
    return CloseIOHangingSwitch(rest).do_close()


class CloseIOHangingSwitch:
    def __init__(self, rest):
        self.rest = rest
        self.err_msgs = list()
        self.ret_list = list()

    @staticmethod
    def get_base_url():
        return RestUtil.getDstorageUrlHead(common.get_device_node(ENV))

    def do_close(self):
        self.execute_close_cmd()
        self.check_is_close_success()
        return self.handle_result()

    def execute_close_cmd(self):
        cmd_str = "{}/dsware/service/cluster/globalParametersOperation".format(self.get_base_url())
        self.ret_list.append(cmd_str)
        param = {
            "opType": "modify",
            "parameter": [{
                "paraName": "g_dsware_io_hanging_switch",
                "value": "close"
            }]
        }
        res_json = CommonRestService.execute_post_request(self.rest, cmd_str, param)
        self.ret_list.append(str(res_json))
        if res_json.get("result") != 0:
            self.err_msgs.append(common.get_err_msg(LANG, 'close.io.hanging.failed'))

    def check_is_close_success(self):
        cmd_str = "{}/dsware/service/cluster/querySysPara".format(self.get_base_url())
        self.ret_list.append(cmd_str)
        res_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str,
                                                            params={"paraName": "g_dsware_io_hanging_switch"})
        self.ret_list.append(str(res_json))
        if res_json.get("parameter") and res_json.get("parameter")[0].get("value") == "close":
            return
        self.err_msgs.append(common.get_err_msg(LANG, 'close.io.hanging.failed'))

    def handle_result(self):
        if self.err_msgs:
            return common.INSPECT_UNNORMAL, str("\n".join(self.ret_list)), "\n".join(self.err_msgs)
        return common.INSPECT_PASS, str("\n".join(self.ret_list)), ""
