# coding: UTF-8
import threading

import common

ENV = py_java_env
ITEM_ID = 'close_lldp'
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(py_java_env)


def execute(rest):
    return CloseLLDP(LOGGER).do_close_lldp()


def partition_list(ori_list, size):
    return [ori_list[i:i + size] for i in range(0, len(ori_list), size)]


class CloseLLDP:
    def __init__(self, log):
        self.select_nodes = [node for node in common.get_cluster_nodes(common.get_device_node(ENV))
                             if node.isSelected()]
        self.max_thread_num = common.get_max_work_thread_num_from_sys_properties(log)
        self.partition_nodes = partition_list(self.select_nodes, self.max_thread_num)
        self.eve_progress = int((1.0 / len(self.select_nodes)) * 100) if len(self.select_nodes) != 0 else 0
        self.log = log
        self.ret_list = list()
        self.err_msgs = list()
        self.progress_observer = common.ProgressObserver({ITEM_ID: 1}, ITEM_ID, common.get_progress_observer(ENV))

    def do_close_lldp(self):
        for nodes in self.partition_nodes:
            self.start_threads_and_waiting(nodes)
        return self.handle_result()

    def start_threads_and_waiting(self, nodes):
        threads = list()
        for node in nodes:
            if not node.getOsNode():
                self.err_msgs.append(common.get_err_msg(LANG, "config.lldp.no.auth.node.failed").format(
                    node.getManagementIp()))
                continue
            if not node.includedStorageService():
                self.err_msgs.append(common.get_err_msg(LANG, "config.lldp.no.storage.node.failed").format(
                    node.getManagementIp()))
                continue
            threads.append(self.init_new_thread(node.getOsNode()))
        self.log.logInfo("start threads:{}".format(threads))
        for thread in threads:
            thread.start()
        for thread in threads:
            thread.join()

    def init_new_thread(self, node):
        return threading.Thread(
            target=self.execute_close_cmd,
            args=(node,)
        )

    def execute_close_cmd(self, node):
        self.log.logInfo("node {} begin to close lldpad".format(node.getIp()))
        rets = list()
        rets.append("--{}--".format(node.getIp()))
        ssh = common.get_ssh_conn(node)
        stop_cmd = "systemctl stop lldpad"
        res_stop = ssh.execCmdWithTimout(stop_cmd, common.HOST_CMD_SHORT_TIMEOUT)
        rets.append(res_stop)

        disable_cmd = "systemctl disable lldpad"
        res_disable = ssh.execCmdWithTimout(disable_cmd, common.HOST_CMD_SHORT_TIMEOUT)
        rets.append(res_disable)

        self.ret_list.extend(rets)
        self.update_one_node_progress()

    def handle_result(self):
        if self.err_msgs:
            return common.INSPECT_UNNORMAL, "\n".join(self.ret_list), "\n".join(self.err_msgs)
        return common.INSPECT_PASS, "\n".join(self.ret_list), ""

    def update_one_node_progress(self):
        self.progress_observer.refresh_progress(self.eve_progress if self.eve_progress != 0 else 1)
