# coding: UTF-8

import common
from ds_rest_util import CommonRestService
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil

ENV = py_java_env
LANG = common.getLang(py_java_env)


def execute(rest):
    return ConfigCompressionRatio(rest).do_config(get_compression_ratio_value())


def get_compression_ratio_value():
    compression_ratio = ENV.get("compression_ratio")
    return compression_ratio if compression_ratio is not None else 1.08


def build_full_version(version, patch_version, hot_patch_version):
    """
    拼接热补丁版本。
    如果产品版本有sph热补丁版本，则直接显示sph，忽略spc；否则显示spc
    :param version: 产品版本
    :param patch_version: 补丁版本
    :param hot_patch_version: 热补丁版本
    :return:
    """
    if not hot_patch_version:
        if not patch_version:
            return version
        if ".SP" in version.upper():
            return version
        if version in patch_version:
            return patch_version
        return version + "." + patch_version
    # 产品版本包含sph,为完整热补丁版本，直接使用
    if ".SPH" in version.upper():
        return version
    # 当前热补丁版本包含. 为完整热补丁版本，直接使用
    if "." in hot_patch_version:
        return hot_patch_version
    # 产品版本中包含spc,截取产品版本大，拼接热补丁版本
    base_version = version
    if ".SPC" in version.upper():
        base_version_end_index = version.upper().find(".SPC")
        base_version = version[:base_version_end_index]
    return base_version + "." + hot_patch_version


class ConfigCompressionRatio:
    def __init__(self, rest):
        self.rest = rest
        self.err_msgs = list()
        self.ret_list = list()

    @staticmethod
    def get_base_url():
        return RestUtil.getDstorageUrlHead(common.get_device_node(ENV))

    def do_config(self, compression_ratio):
        if not self.check_involve():
            return common.INSPECT_NOSUPPORT, u"\n".join(self.ret_list), "\n".join(self.err_msgs)
        self.execute_config_cmd(compression_ratio)
        return self.handle_result()

    def check_involve(self):
        return self.is_target_pool_type()

    def is_target_pool_type(self):
        cmd_str = "{}/dsware/service/resource/queryPoolBasicInfo".format(self.get_base_url())
        self.ret_list.append("\n" + cmd_str)
        res_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str)
        self.ret_list.append(str(res_json))
        pools = res_json.get("pools", [])
        if len(pools) < 1:
            self.err_msgs.append(common.get_err_msg(LANG, 'config.compression.ratio.not.involved.no.pool.inf'))
            return False
        pool_type = pools[0].get("poolType", "")
        if pool_type == "sata3copy":
            return True
        self.err_msgs.append(common.get_err_msg(LANG, 'config.compression.ratio.not.involved.pool.type', pool_type))
        return False

    def execute_config_cmd(self, compression_ratio):
        cmd_str = "{}/dsware/service/cluster/globalParametersOperation".format(self.get_base_url())
        self.ret_list.append("\n" + cmd_str)
        param = {
            "opType": "modify",
            "parameter": [{
                "paraName": "compression_ratio",
                "value": str(compression_ratio)
            }]
        }
        res_json = CommonRestService.execute_post_request(self.rest, cmd_str, param)
        self.ret_list.append(str(res_json))
        if res_json.get("result") != 0:
            self.err_msgs.append(common.get_err_msg(LANG, 'config.compression.ratio.failed'))
            return
        self.check_is_config_success(compression_ratio)

    def check_is_config_success(self, compression_ratio):
        cmd_str = "{}/dsware/service/cluster/querySysPara".format(self.get_base_url())
        self.ret_list.append("\n" + cmd_str)
        res_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str,
                                                            params={"paraName": "compression_ratio"})
        self.ret_list.append(str(res_json))
        if res_json.get("parameter") and float(res_json.get("parameter")[0].get("value")) == compression_ratio:
            return
        self.err_msgs.append(common.get_err_msg(LANG, 'config.compression.ratio.failed'))

    def handle_result(self):
        if self.err_msgs:
            return common.INSPECT_UNNORMAL, u"\n".join(self.ret_list), "\n".join(self.err_msgs)
        return common.INSPECT_PASS, u"\n".join(self.ret_list), ""
