# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_disk_status"


def execute(rest):
    """
    检查盘状态
    :param env:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageBaseUrlNoV2(dev_node)
        deviceEsn = dev_node.getDeviceSerialNumber()
        cmd_str = "{}/deviceManager/rest/{}/ntp_client_config".format(
            base_uri, deviceEsn
        )
        ret_list.append(cmd_str)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(pools_json))
        respData = pools_json.get("data")
        if len(respData) != 0:
            if (respData[0].get("CMO_SYS_NTP_CLNT_CONF_SWITCH") == "1") and \
                    (respData[0].get("CMO_SYS_NTP_CLNT_CONF_SERVER_IP")):
                return common.INSPECT_PASS, "\n".join(ret_list), ""

        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.ntp.result.not.pass")
        )
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
