# coding: UTF-8

import common
from ds_rest_util import CommonRestService
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil

ENV = py_java_env
LANG = common.getLang(py_java_env)


def execute(rest):
    return ConfigScsiAbortTimeOut(rest).do_config(get_time_out_value())


def get_time_out_value():
    timeout_value = ENV.get("scsi_driver_timeout")
    return timeout_value if timeout_value is not None else 90


class ConfigScsiAbortTimeOut:
    def __init__(self, rest):
        self.rest = rest
        self.err_msgs = list()
        self.ret_list = list()

    @staticmethod
    def get_base_url():
        return RestUtil.getDstorageUrlHead(common.get_device_node(ENV))

    def do_config(self, time_out):
        self.execute_config_cmd(time_out)
        self.check_is_config_success(time_out)
        return self.handle_result()

    def execute_config_cmd(self, time_out):
        cmd_str = "{}/dsware/service/cluster/globalParametersOperation".format(self.get_base_url())
        self.ret_list.append(cmd_str)
        param = {
            "opType": "modify",
            "parameter": [{
                "paraName": "abort_timeout",
                "value": str(time_out)
            }]
        }
        res_json = CommonRestService.execute_post_request(self.rest, cmd_str, param)
        self.ret_list.append(str(res_json))
        if res_json.get("result") != 0:
            self.err_msgs.append(common.get_err_msg(LANG, 'config.scsi.abort.timeout.failed'))

    def check_is_config_success(self, time_out):
        cmd_str = "{}/dsware/service/cluster/querySysPara".format(self.get_base_url())
        self.ret_list.append(cmd_str)
        res_json = CommonRestService.exec_get_gor_big_by_ds(self.rest, cmd_str, params={"paraName": "abort_timeout"})
        self.ret_list.append(str(res_json))
        if res_json.get("parameter") and str(res_json.get("parameter")[0].get("value")) == str(time_out):
            return
        self.err_msgs.append(common.get_err_msg(LANG, 'config.scsi.abort.timeout.failed'))

    def handle_result(self):
        if self.err_msgs:
            return common.INSPECT_UNNORMAL, str("\n".join(self.ret_list)), "\n".join(self.err_msgs)
        return common.INSPECT_PASS, str("\n".join(self.ret_list)), ""
