# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
import re
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "dsm_bios_match_check"


def get_storage_software(dev_node):
    """
    :function: 获取存储软件版本
    :param version: 节点信息
    :return: 存储软件版本
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getHotPatchVersion()
    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    elif not patch_version:
        return product_version
    else:
        return product_version + "." + patch_version


def check_storage_software(version):
    """
    :function: 存储软件风险配套检查
    :param version: 当前存储软件版本
    :return: True：检查通过；False:存在风险软件配套关系
    """
    black_product_ver = (
        "8.1.0", "8.1.0.SPH1", "8.1.0.SPH2", "8.1.0.SPH3", "8.1.0.SPH5",
        "8.1.0.SPH6",
        "8.1.1", "8.1.RC2", "8.1.1.SPH1", "8.1.1.SPH2", "8.1.1.HP2",
        "8.1.1.HP3",
        "8.1.1.HP5")
    # 服务器BIOS风险版本与存储软件配套检查
    for black_ver in black_product_ver:
        if black_ver == version:
            return False
    return True


def execute(rest):
    dev_node = py_java_env.get("devInfo")
    try:
        """
        检查存储池是否开启DSM特性
        如果DSM特性开关未开启，则检查通过，否则继续执行
        """
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/resource/queryStoragePool".format(base_uri)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        if not pools_json.get("storagePools"):
            return common.INSPECT_PASS, "\n".join(pools_json), ""

        storage_pools = pools_json.get("storagePools", [])
        dsm_switch = storage_pools[0].get("dsmSwitch")
        LOGGER.logInfo("dsm_switch is:%s." % str(dsm_switch))
        if dsm_switch != 1:
            return common.INSPECT_PASS, "dsm_switch = {}".format(
                dsm_switch), ""  # 没有开启DSM开关，无风险

        """
        检查风险存储软件版本号
        如果不在风险版本范围内，则检查通过，否则继续执行
        """
        product_version = get_storage_software(dev_node)
        LOGGER.logInfo("product_version is:%s." % str(product_version))
        software_result = check_storage_software(product_version)
        if software_result:
            return common.INSPECT_PASS, "product_version = {}".format(
                product_version), ""  # 软件版本不在风险版本列表内，没有风险

        return check_new_expansion_nodes_bios(product_version)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_new_expansion_nodes_bios(product_version):
    """
    获取待扩节点信息
    """
    dev_scaleNodes = py_java_env.get("newExpansionNodes")
    bios_ret = True
    scale_ip = []
    bios_versions = []
    alpha_re = re.compile(r'[A-Za-z]')
    for scale_node in dev_scaleNodes:
        cmd = "dmidecode -t 0 | grep 'Version' | awk '{print $2}'"
        ssh = common.get_ssh_conn(scale_node)
        bios_version_rsp = ssh.execCmdWithTimout(cmd,
                                                 common.HOST_CMD_SHORT_TIMEOUT).splitlines()
        common.release_ssh_conn(ssh)
        bios_version = bios_version_rsp[1]
        LOGGER.logInfo("bios_version is:%s." % str(bios_version))
        if len(bios_version) > 4:
            continue
        elif bool(re.match(alpha_re, bios_version)):
            continue
        elif float(bios_version) >= 1.83 and float(bios_version) < 2:
            bios_ret = False
            scale_ip.append(" ".join(scale_node.getIp()))
            bios_versions.append(" " + bios_version)
        elif float(bios_version) >= 3.37 and float(bios_version) < 4:
            bios_ret = False
            scale_ip.append(" ".join(scale_node.getIp()))
            bios_versions.append(" " + bios_version)
        else:
            continue
    if bios_ret:
        return common.INSPECT_PASS, "\n" + "check pass! productVersion:{}".format(
            product_version), ""  # BIOS版本不在风险版本列表内，没有风险
    else:
        return common.INSPECT_UNNORMAL, "\n" + "productVersion:{} problem " \
                                               "nodeIP:{} BIOS:{}".format(
            product_version, scale_ip, bios_versions), common.get_err_msg(
            LANG, "check.result.dsm.bios.missmatch", (
                scale_ip, "".join(bios_versions),
                product_version)),  # 查出软件版本和BIOS版本不配套
