# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "fail_over_status"


def execute(rest):
    """
    检查故障倒换状态
    :param rest:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        # 813之前的版本不涉及该巡检项
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "\n".join(ret_list), "Not support."

        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/fail_over/checkfailoverstatus".format(
            base_uri
        )

        # 访问fsm的rest接口
        result_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(result_json))

        # 校验结果
        # 没有result
        result = result_json.get("result")
        if result is None:
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "common.error", "other error."),
            )

        # 存在有非正常状态的节点
        if result == 4:
            details = result_json.get("detail", [])
            error_ips = []
            for detail in details:
                error_ips.append(detail.get("ip"))
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "check.fail.over.status.error", ", ".join(error_ips)),
            )

        # 其他系统错误，此处result一般为2
        if result != 0:
            description = result_json.get("description")
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "common.error", description),
            )

        # 校验通过
        return common.INSPECT_PASS, ret_list, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version.__len__() < 3:
        return False
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False
