# coding: UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from com.huawei.ism.exception import IsmException

import cli_util
import common

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "fsm_bmc_time"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env

EAST_8 = "+08:00"
TIME_ZONE_LIST = ["Asia/Shanghai", "Asia/Chongqing"]


def execute(rest):
    """
    检查BMC时区
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["logger"] = LOGGER
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_bmc_time_info(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_bmc_time_info(param_dict, cluster_dev_node, err_info_list, ret_list):
    """
    检查BMC时区
    :param param_dict: 参数列表
    :param ibmc_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list: 回文
    :return:
    """
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    redfish_conn = common.get_redfish_conn(cluster_dev_node)
    ret_by_node = []
    flag, manager_id_info = get_manager_id_info(redfish_conn, ret_by_node)
    if any([flag is not True,
            not manager_id_info,
            not manager_id_info.get("Members")]):
        ret_list.append(cli_util.get_format_header_ret(cluster_node_ip,
                                                       "\n".join(ret_by_node)))
        err_info_list.append(common.get_err_msg(
            LANG, "hardware.status.check.failed", cluster_node_ip, ))
        return
    manager_id = manager_id_info.get(
        "Members")[0].get("@odata.id").split("/")[-1]
    flag, ret_json = get_bmc_time(redfish_conn, manager_id, ret_by_node)
    ret_list.append(cli_util.get_format_header_ret(cluster_node_ip,
                                                   "\n".join(ret_by_node)))
    if flag is not True:
        err_info_list.append(common.get_err_msg(
            LANG, "hardware.status.check.failed", cluster_node_ip, ))
        return
    check_bmc_time(cluster_dev_node, err_info_list, ret_json)


def get_manager_id_info(redfish_conn, ret_by_node):
    manager_id_url = "/Managers"
    ret_by_node.append(manager_id_url)
    flag, manager_id_info = cli_util.execute_redfish_get(redfish_conn,
                                                         manager_id_url)
    ret_by_node.append(str(manager_id_info))
    return flag, manager_id_info


def get_bmc_time(redfish_conn, manager_id, ret_by_node):
    get_bmc_time_url = "/Managers/{}".format(manager_id)
    flag, ret_json = cli_util.execute_redfish_get(redfish_conn,
                                                  get_bmc_time_url)
    ret_by_node.append(get_bmc_time_url)
    ret_by_node.append(str(ret_json))
    return flag, ret_json


def check_bmc_time(cluster_dev_node, err_info_list, ret_json):
    date_time = ret_json.get("DateTime", [])
    time_zone = ret_json.get("DateTimeLocalOffset", [])
    if all([EAST_8 not in date_time,
            time_zone not in TIME_ZONE_LIST]):
        err_info_list.append(
            common.get_err_msg(LANG, "fsm.bmc.time.not.pass",
                               common.get_node_ip(cluster_dev_node), ))


def execute_redfish_get(cluster_dev_node, url):
    """
    执行redfish的get命令
    :param cluster_dev_node:
    :param url:
    :return:
    """
    redfish_conn = common.get_redfish_conn(cluster_dev_node)
    return cli_util.execute_redfish_get(redfish_conn, url)
