# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "fsm_node_out_timeout"
PARAMETER_NAME = "g_node_out_timeout_normal"
INITIAL_VALUE = "10080"


def execute(rest):
    """
    检查重构时间配置
    :param env:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/cluster/queryGlobalParametersOperation?paraName=g_node_out_timeout_normal".format(
            base_uri
        )
        ret_list.append(cmd_str)
        response_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(response_json))
        check_ok = check_response(response_json)
        if not check_ok:
            return common.INSPECT_UNNORMAL, "\n".join(ret_list), common.get_err_msg(LANG, "query.result.abnormal")

        progressMap[ITEM_ID] = 50
        observer.updateProgress(progressMap)
        parameters = response_json.get("parameter")

        if not parameters:
            return (
                common.INSPECT_UNNORMAL,
                "\n".join(ret_list),
                common.get_err_msg(LANG, "query.result.abnormal"),
            )

        for parameter in parameters:
            if parameter.get("paraName") == PARAMETER_NAME and parameter.get("value") != INITIAL_VALUE:
                return common.INSPECT_UNNORMAL, "\n".join(ret_list), parameter.get("value")

        return common.INSPECT_PASS, "\n".join(ret_list), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_response(response):
    if response and isinstance(response, dict):
        if str(response.get("result")) == '0':
            return True
    return False
