# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_bbu_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查盘状态
    :param env:
    :return:
    """
    ret_list_dict = dict()
    ret_list = list()
    err_info_list = list()
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = dict()
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["logger"] = LOGGER
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_battery_unit_status(
            param_dict, None, err_info_list, ret_list_dict)
        [ret_list.extend(t_ret) for t_ret in ret_list_dict.values()]
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        LOGGER.logInfo("all_ret:{}".format(all_ret))
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_battery_unit_status(param_dict, cluster_dev_node, err_info_list, ret_dict):
    ibmc_ssh = common.get_ibmc_ssh_conn(cluster_dev_node)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    LOGGER.logInfo("check_bbu_status:{} STARTED.".format(cluster_node_ip))
    flag, ret = cli_util.execute_cmd(ibmc_ssh, "ipmcget -d bbuinfo")
    common.release_bmc_ssh_conn(cluster_dev_node)
    tmp_ret = cli_util.get_format_header_ret(cluster_node_ip, ret)
    cli_util.update_ret_dict(ret_dict, cluster_node_ip, tmp_ret)
    if flag is not True:
        return
    res_dict_list = cli_util.get_vertical_cli_ret(ret)
    if not res_dict_list:
        return
    error_bbu_id_list = []
    for res_dict in res_dict_list:
        bbu_remain_cap = int(res_dict.get("Remain Capacity(%)", "0"))
        if any(
                [
                    bbu_remain_cap <= 10,
                    res_dict.get("BBU Health", "") != "Normal",
                    res_dict.get("Work Status", "") != "CHARGE_FULL",
                ]
        ):
            error_bbu_id_list.append(res_dict.get("BBU ID"))
    if error_bbu_id_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.bbu.status.not.pass",
                (cluster_node_ip, ",".join(error_bbu_id_list)),
            )
        )
