# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_disk_status"


def execute(rest):
    """
    检查盘状态
    :param env:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = {}
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        cmd_str = "{}/dsware/service/resource/queryStoragePool".format(
            base_uri
        )
        ret_list.append(cmd_str)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(pools_json))
        if not pools_json.get("storagePools"):
            return common.INSPECT_PASS, "\n".join(ret_list), ""

        progressMap[ITEM_ID] = 10
        observer.updateProgress(progressMap)
        tmp_err_dict = {}
        storage_pools = pools_json.get("storagePools", [])
        check_storage_pools(base_uri, rest, ret_list, storage_pools,
                            tmp_err_dict)

        progressMap[ITEM_ID] = 80
        observer.updateProgress(progressMap)

        all_ret = "\n".join(ret_list)
        if tmp_err_dict:
            msg_list = []
            for node_ip, err_msg_list in tmp_err_dict.items():
                msg_list.append(
                    common.get_err_msg(LANG,
                                       "hardware.disk.status",
                                       (node_ip, "\n".join(err_msg_list)), ))
            return common.INSPECT_UNNORMAL, all_ret, "".join(msg_list)

        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_storage_pools(base_uri, rest, ret_list, storage_pools, tmp_err_dict):
    for record in storage_pools:
        pool_id = record.get("poolId")
        if pool_id is None:
            continue
        cmd_str = (
            "{}/dsware/service/cluster/storagepool/"
            "queryNodeDiskInfo?poolId={}".format(base_uri, pool_id)
        )
        ret_list.append(cmd_str)
        node_json = \
            CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        ret_list.append(str(node_json))
        if not node_json.get("nodeInfo"):
            continue
        chec_node_in_pool(node_json, pool_id, tmp_err_dict)


def chec_node_in_pool(node_json, pool_id, tmp_err_dict):
    nodes_info = node_json.get("nodeInfo", [])
    for node_info in nodes_info:
        disk_list = node_info.get("mediaInfo", [])
        node_mgr_ip = node_info.get("nodeMgrIp", "")
        if (disk_list is None) or \
                (node_info.get("errorCode", 0) != 0):
            tmp_list = tmp_err_dict.get(node_mgr_ip, [])
            tmp_list.append(
                common.get_err_msg(LANG, "query.pool.result.abnormal",
                                   pool_id))
            tmp_err_dict[node_mgr_ip] = tmp_list
            continue

        check_disk_in_pool(disk_list, node_mgr_ip, tmp_err_dict)


def check_disk_in_pool(disk_list, node_mgr_ip, tmp_err_dict):
    for disk_info in disk_list:
        disk_exist = disk_info.get("diskExist")
        disk_status = disk_info.get("diskStatus")
        disk_slot = disk_info.get("diskSlot")
        disk_in_pools = disk_info.get("pools", [])
        disk_type = disk_info.get("diskType")
        disk_sn = disk_info.get("diskSn")
        if not disk_in_pools:
            continue

        if disk_exist == 0 and disk_status == 0:
            continue

        tmp_list = tmp_err_dict.get(node_mgr_ip, [])
        if disk_type == "ssd_card" and disk_exist != 0:
            tmp_list.append(
                "  diskSn:%s, diskExist:%s, diskStatus:%s" % (
                    disk_sn, disk_exist, disk_status))
        else:
            tmp_list.append(
                "  diskSlot:%s, diskExist:%s, diskStatus:%s" % (
                    disk_slot, disk_exist, disk_status))
        tmp_err_dict[node_mgr_ip] = tmp_list
