# coding: UTF-8

from com.huawei.ism.exception import IsmException

import common
import check_main_storage

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_extend_main_storage"


def execute(rest):
    """
    检查主存盘
    :param env:
    :return:
    """
    ret_list = common.get_err_msg(LANG, "expansion.config.info")
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    tmp_warning_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")
        for pool in storage_pools:
            msg_head = common.get_err_msg(LANG,
                                          "storage.pool.msg",
                                          pool.getName())
            check_main_storage.check_main_storage(pool, tmp_err_list,
                                                  tmp_warning_list, msg_head,
                                                  LANG)
        if tmp_err_list:
            tmp_err_list.extend(tmp_warning_list)
            return common.INSPECT_UNNORMAL, ret_list, "\n".join(tmp_err_list)
        if tmp_warning_list:
            return common.INSPECT_WARNING, ret_list, "\n".join(
                tmp_warning_list)
        return common.INSPECT_PASS, ret_list, ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, ret_list,
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
