# coding: UTF-8

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.entity import ClusterNode
from com.huawei.ism.tool.obase.entity import DiskTypeEnum

import check_main_storage
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_extend_main_storage"


def execute(rest):
    """
    检查主存盘
    :param env:
    :return:
    """
    ret_list = common.get_err_msg(LANG, "expansion.config.info")
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    tmp_warning_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")
        for storage_pool in storage_pools:
            for disk_pool in storage_pool.getDiskPools():
                msg_head = common.get_err_msg(LANG,
                                              "storage.pool.disk.pool.msg",
                                              (storage_pool.getName(),
                                               disk_pool.getName()))
                check_main_storage.check_main_storage(disk_pool, tmp_err_list,
                                                      tmp_warning_list,
                                                      msg_head, LANG)
                # 810专属的检查
                check_disk_number_by_disk_zone(disk_pool, tmp_err_list,
                                               msg_head, LANG)
                check_all_disk_pool_disk_type(disk_pool, tmp_err_list,
                                              msg_head, LANG)
        if tmp_err_list:
            tmp_err_list.extend(tmp_warning_list)
            return common.INSPECT_UNNORMAL, ret_list, "\n".join(tmp_err_list)
        if tmp_warning_list:
            return common.INSPECT_WARNING, ret_list, "\n".join(
                tmp_warning_list)
        return common.INSPECT_PASS, ret_list, ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, ret_list,
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_all_disk_pool_disk_type(pool, tmp_err_list, msg_head, lang):
    # 大西洋节点，主存盘只能为SSD卡&NVME SSD
    if pool.getMainStorageDiskType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD:
        # 太平洋节点，主存盘不能为SSD卡&NVME SSD，如果存在记录错误信息
        error_nodes = get_nodes_by_type(pool,
                                        ClusterNode.BaseBoardType.PACIFIC)
        if error_nodes:
            tmp_err_list.append(
                common.get_err_msg(lang,
                                   "can.not.select.pacific.node",
                                   (msg_head,
                                    ",".join(error_nodes))))
    else:
        # 大西洋节点，新大西洋节点，主存盘只能为SSD卡&NVME SSD
        error_nodes = get_nodes_by_type(pool, ClusterNode.BaseBoardType.ATLANTIC)
        error_nodes.extend(get_nodes_by_type(pool, ClusterNode.BaseBoardType.NEW_ATLANTIC))
        if error_nodes:
            tmp_err_list.append(
                common.get_err_msg(lang,
                                   "can.not.select.atlantic.node.storage",
                                   (msg_head,
                                    ",".join(error_nodes))))


def get_nodes_by_type(disk_pool, node_type):
    """
    从diskpool中根据节点类型获取节点列表
    :param disk_pool: 硬盘池
    :param node_type: 节点类型
    :return: 节点列表
    """
    filter_result = []
    filter_cluster_node_list_by_type(disk_pool.getJoinedClusterNode(),
                                     node_type, filter_result)
    filter_cluster_node_list_by_type(
        disk_pool.getExpansionClusterNode(), node_type, filter_result)
    filter_node_list_by_type(disk_pool.getExpansionNodeList(), node_type,
                             filter_result)
    return filter_result


def filter_cluster_node_list_by_type(cluster_node_list, node_type,
                                     filter_result):
    result_nodes = list(
        filter(lambda node: node.getBaseBoardType() == node_type,
               cluster_node_list))
    filter_result.extend([node.getManagementIp() for node in result_nodes])


def filter_node_list_by_type(node_list, node_type, filter_result):
    result_nodes = list(
        filter(lambda node: node.getBaseBoardType() == node_type,
               node_list))
    filter_result.extend([node.getIp() for node in result_nodes])


def check_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang):
    # 分别调用太平洋和东海的判断存盘方法
    below_minimum_node = []
    exceeds_maximum_node = []
    check_east_disk_number_by_disk_zone(pool, below_minimum_node, exceeds_maximum_node)
    check_pacific_disk_number_by_disk_zone(pool, below_minimum_node, exceeds_maximum_node)
    if below_minimum_node:
        tmp_err_list.append(
            common.get_err_msg(lang,
                               "pool.main.storage.disk.num.below.min",
                               (msg_head,
                                ",".join(below_minimum_node))))
    if exceeds_maximum_node:
        tmp_err_list.append(
            common.get_err_msg(lang,
                               "pool.main.storage.disk.num.exceeds.max",
                               (msg_head, ",".join(exceeds_maximum_node))))


def check_east_disk_number_by_disk_zone(pool, below_minimum_node, exceeds_maximum_node):
    single_node_and_disk_num_dic, dual_node_and_disk_num_dic = common. \
        get_east_node_and_disk_num_dic(pool, common.MAIN_STORAGE_DISK_TYPE)
    # 东海单控主存盘 [16,60]，东海双控主存盘 [8,30]
    # 东海单控分为 4 个disk zone，东海双控分为 2 个disk zone，每个硬盘数相等（界面拦截），硬盘数为[4,15]
    for node_ip, disk_num in single_node_and_disk_num_dic.items():
        if disk_num < 16:
            below_minimum_node.append(node_ip)
        if disk_num > 60:
            exceeds_maximum_node.append(node_ip)
    for node_ip, disk_num in dual_node_and_disk_num_dic.items():
        if disk_num < 8:
            below_minimum_node.append(node_ip)
        if disk_num > 30:
            exceeds_maximum_node.append(node_ip)


def check_pacific_disk_number_by_disk_zone(pool, below_minimum_node, exceeds_maximum_node):
    node_and_disk_num_dic = common. \
        get_pacific_node_and_disk_num_dic(pool, common.MAIN_STORAGE_DISK_TYPE)
    # 太平洋节点，分为四个disk zone，每个硬盘数相等（界面拦截），硬盘数为[4,15]
    # 因此加入池中的主存盘最少为16，最大为60
    for node_ip, disk_num in node_and_disk_num_dic.items():
        if disk_num < 16:
            below_minimum_node.append(node_ip)
        if disk_num > 60:
            exceeds_maximum_node.append(node_ip)
