# coding: UTF-8
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.entity import DiskTypeEnum

import common
import check_pool_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CATCHE_TYPE = {DiskTypeEnum.SSD_CARD_AND_NVME_SSD: "ssd_card",
               DiskTypeEnum.SSD: "ssd_disk"}
ITEM_ID = "hardware_extend_nvme"


def execute(rest):
    """
    检查缓存盘
    :param env:
    :return:
    """
    ret_list = common.get_err_msg(LANG, "expansion.config.info")
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")
        for pool in storage_pools:
            msg_head = common.get_err_msg(LANG,
                                          "storage.pool.msg",
                                          pool.getName())
            check_pool_cache.check_pool_cache_disk(pool, tmp_err_list,
                                                   msg_head, LANG)
        if tmp_err_list:
            return common.INSPECT_UNNORMAL, ret_list, \
                   "\n".join(tmp_err_list)
        return common.INSPECT_PASS, ret_list, ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, ret_list,
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
