# coding: UTF-8
import json
import re

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.entity import DiskTypeEnum
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from ds_rest_util import CommonRestService

import check_pool_cache
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CATCHE_TYPE = {DiskTypeEnum.SSD_CARD_AND_NVME_SSD: "ssd_card",
               DiskTypeEnum.SSD: "ssd_disk"}
ITEM_ID = "hardware_extend_nvme"
HANDLE = py_java_env.get("preInspectHandle")
PRE_ITEM_ID = "get_white_list_and_disk_model"

tmp_errs = []
msg_head = ''
ret_list = []


def execute(rest):
    """
    检查缓存盘
    :param env:
    :return:
    """
    ret_list.append(common.get_err_msg(LANG, "expansion.config.info"))
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")
        trim_white_list = get_trim_white_list(dev_node)
        ret_list.append(str(["trim_white_list", trim_white_list]))
        for storage_pool in storage_pools:
            is_block = storage_pool.isBlock()
            for disk_pool in storage_pool.getDiskPools():
                global msg_head
                msg_head = common.get_err_msg(LANG,
                                              "storage.pool.disk.pool.msg",
                                              (storage_pool.getName(),
                                               disk_pool.getName()))
                check_pool_cache.check_pool_cache_disk(disk_pool, tmp_errs,
                                                       msg_head, LANG)
                # 810专属的检查
                check_disk_number_by_disk_zone(disk_pool)
                check_pool_cache.check_pool_cache_min_size_disk(disk_pool, is_block, tmp_errs, msg_head, LANG)
                check_pool_disk_white_list(trim_white_list, disk_pool, is_block, tmp_errs, LANG)
        if tmp_errs:
            return common.INSPECT_UNNORMAL, '\n'.join(ret_list), "\n".join(tmp_errs)
        return common.INSPECT_PASS, '\n'.join(ret_list), ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, '\n'.join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_disk_number_by_disk_zone(disk_pool):
    # 分别调用太平洋和东海的判断存盘方法
    check_east_disk_number_by_disk_zone(disk_pool)
    check_pacific_disk_number_by_disk_zone(disk_pool)


def check_east_disk_number_by_disk_zone(disk_pool):
    single_node_and_disk_num_dic, dual_node_and_disk_num_dic = \
        common.get_east_node_and_disk_num_dic(disk_pool, common.CACHE_DISK_TYPE)

    node_and_disk_num_dic = {}
    node_and_disk_num_dic.update(dual_node_and_disk_num_dic)
    node_and_disk_num_dic.update(single_node_and_disk_num_dic)
    LOGGER.logInfo("node_and_disk_num_dic{}".format(node_and_disk_num_dic))
    get_east_disk_number_err_info(node_and_disk_num_dic, disk_pool)


def get_east_disk_number_err_info(node_and_disk_num_dic, disk_pool):
    # 东海单控双P 缓存盘数量： 1~4；东海其他 缓存盘数量：1~2
    err_nodes_ip_1_4 = []
    err_nodes_ip_1_2 = []
    sc_dp_nodes_ip = get_single_controller_dual_processor_nodes_ip(disk_pool)
    for node_ip, disk_num in node_and_disk_num_dic.items():
        if node_ip in sc_dp_nodes_ip:
            if disk_num == 0 or disk_num > 4:
                err_nodes_ip_1_4.append(node_ip)
        else:
            if disk_num == 0 or disk_num > 2:
                err_nodes_ip_1_2.append(node_ip)
    if err_nodes_ip_1_4:
        tmp_errs.append(
            common.get_err_msg(LANG, "east.cache.disk.num.non.conformity.1to4", (msg_head, ",".join(err_nodes_ip_1_4))))
    if err_nodes_ip_1_2:
        tmp_errs.append(
            common.get_err_msg(LANG, "east.cache.disk.num.non.conformity.1or2", (msg_head, ",".join(err_nodes_ip_1_2))))


def get_single_controller_dual_processor_nodes_ip(disk_pool):
    nodes = []
    nodes.extend(disk_pool.getJoinedClusterNode())
    nodes.extend(disk_pool.getExpansionClusterNode())
    sc_dp_nodes_ip = []
    for node in nodes:
        if node.isEastSeaSingleNodeDualProcessor():
            sc_dp_nodes_ip.append(node.getManagementIp())
    for node in disk_pool.getExpansionNodeList():
        if node.isEastSeaSingleNodeDualProcessor():
            sc_dp_nodes_ip.append(node.getIp())
    LOGGER.logInfo('sc_dp_nodes_ip：{}'.format(sc_dp_nodes_ip))
    return sc_dp_nodes_ip


def check_pacific_disk_number_by_disk_zone(pool):
    if is_no_cache_disk_scene(pool):
        return
    node_and_disk_num_dic = common. \
        get_pacific_node_and_disk_num_dic(pool, common.CACHE_DISK_TYPE)
    error_node_ip = []
    # 太平洋节点，每个节点缓存盘数量为1~4
    for node_ip, disk_num in node_and_disk_num_dic.items():
        if disk_num > 4 or disk_num == 0:
            error_node_ip.append(node_ip)
    if error_node_ip:
        tmp_errs.append(
            common.get_err_msg(LANG,
                               "pacific.cache.disk.num.non.conformity",
                               (msg_head,
                                ",".join(error_node_ip))))


def check_pool_disk_white_list(trim_white_list, disk_pool, is_block, tmp_err_list, lang):
    """
    不支持第三方缓存盘和自研盘共池
    """
    if is_block or is_no_cache_disk_scene(disk_pool):
        return
    node_in_white_list = {}
    node_list = []
    node_list.extend(disk_pool.getJoinedClusterNode())
    if not node_list:
        return
    node_list.extend(disk_pool.getExpansionClusterNode())
    for node in node_list:
        node_ip = common.get_node_ip(node)
        ret = HANDLE.getTargetCheckResult(node_ip, PRE_ITEM_ID)
        disk_model_list = json.loads(ret).get("disk_model_list")
        ret_list.append(str([node_ip, disk_model_list]))
        intersection = set(disk_model_list) & (set(trim_white_list))
        node_in_white_list[node_ip] = True if len(intersection) == len(set(disk_model_list)) else False
    check_expansion_node_list_disk_model(disk_pool, node_in_white_list, trim_white_list)
    if len(set(node_in_white_list.values())) == 2:
        in_white_list = [k for k, v in node_in_white_list.items() if v]
        out_white_list = [k for k, v in node_in_white_list.items() if not v]
        tmp_err_list.append(common.get_err_msg(lang, "hardware.cache.storage.disk.same.model",
                                               (msg_head, ','.join(in_white_list), ','.join(out_white_list))))


def check_expansion_node_list_disk_model(disk_pool, node_in_white_list, trim_white_list):
    """
    检查新扩容的集群外节点的缓存盘型号是否在白名单中
    """
    expansion_dev_list = disk_pool.getExpansionNodeList()
    cmd = "lsblk -d |grep -v sd |awk '{if(NR>1)print}'| awk '{print $1}'"
    for dev in expansion_dev_list:
        dev_disk_model = []
        ssh = common.get_ssh_conn(dev)
        ret = ssh.execCmdWithTimout(cmd, common.HOST_CMD_SHORT_TIMEOUT)
        for name in ret.splitlines():
            smart_str = ssh.execCmdWithTimout('smartctl -a /dev/{}'.format(name), common.HOST_CMD_SHORT_TIMEOUT)
            disk_model = get_disk_model(smart_str)
            if disk_model:
                dev_disk_model.append(disk_model)
        LOGGER.logInfo("check_expansion_node_list_disk_model:{}".format(dev_disk_model))
        intersection = set(dev_disk_model) & (set(trim_white_list))
        node_in_white_list[dev.getIp()] = True if len(intersection) == len(set(dev_disk_model)) else False
        ret_list.append(str([dev.getIp(), dev_disk_model]))
        common.release_ssh_conn(ssh)


def get_disk_model(smart_str):
    """
    根据smartctl回显获取缓存盘型号
    :param smart_str: smart命令回显
    :return: 缓存盘型号
    """
    disk_model = ""
    for key in ["Device Model", "Model Number"]:
        pattern = re.compile(r"{}:\s+(.*)".format(key), re.M)
        result = pattern.search(smart_str)
        if result:
            disk_model = result.group(1)
    return disk_model.strip()


def get_trim_white_list(dev_node):
    """
    通过预巡检项get_white_list_and_disk_model返回结果中的trim_white_list获取白名单列表
    """
    for node in dev_node.getClusterNodes():
        node_ip = common.get_node_ip(node)
        ret = HANDLE.getTargetCheckResult(node_ip, PRE_ITEM_ID)
        trim_white_list = json.loads(ret).get("trim_white_list") if ret else []
        if trim_white_list:
            return trim_white_list
    return []


def is_no_cache_disk_scene(pool):
    """
    全闪场景不存在缓存盘，不需要检查，此处判断逻辑和DiskTypeEnum枚举中的备注保持一致
    """
    return pool.getMainStorageDiskType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD \
           or pool.getMainStorageDiskType() == DiskTypeEnum.SSD
