# coding: UTF-8
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.entity import DiskTypeEnum

import check_pool_cache
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CATCHE_TYPE = {DiskTypeEnum.SSD_CARD_AND_NVME_SSD: "ssd_card",
               DiskTypeEnum.SSD: "ssd_disk"}
ITEM_ID = "hardware_extend_nvme"


def execute(rest):
    """
    检查缓存盘
    :param env:
    :return:
    """
    ret_list = common.get_err_msg(LANG, "expansion.config.info")
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")

        for storage_pool in storage_pools:
            for disk_pool in storage_pool.getDiskPools():
                msg_head = common.get_err_msg(LANG,
                                              "storage.pool.msg",
                                              (storage_pool.getName()))
                check_pool_cache.check_pool_cache_disk(disk_pool, tmp_err_list,
                                                       msg_head, LANG)
                # 810专属的检查
                check_disk_number_by_disk_zone(disk_pool, tmp_err_list,
                                               msg_head, LANG)
        if tmp_err_list:
            return common.INSPECT_UNNORMAL, ret_list, \
                   "\n".join(tmp_err_list)
        return common.INSPECT_PASS, ret_list, ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL, ret_list,
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang):
    # 分别调用太平洋和东海的判断存盘方法
    check_east_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang)
    check_pacific_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang)


def check_east_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang):
    single_node_and_disk_num_dic, double_node_and_disk_num_dic = common. \
        get_east_node_and_disk_num_dic(pool, common.CACHE_DISK_TYPE)
    east_single_error_node_ip = []
    east_double_error_node_ip = []
    # 东海单控缓存盘 [0,8]，东海双控缓存盘 [0,2]
    for node_ip, disk_num in single_node_and_disk_num_dic.items():
        if disk_num > 8:
            east_single_error_node_ip.append(node_ip)
    if east_single_error_node_ip:
        tmp_err_list.append(
            common.get_err_msg(lang,
                               "pool.cache.disk.num.single.out.of.specification",
                               (msg_head,
                                ",".join(east_single_error_node_ip))))
    for node_ip, disk_num in double_node_and_disk_num_dic.items():
        if disk_num > 2:
            east_double_error_node_ip.append(node_ip)
    if east_double_error_node_ip:
        tmp_err_list.append(
            common.get_err_msg(lang,
                               "pool.cache.disk.num.double.out.of.specification",
                               (msg_head,
                                ",".join(east_double_error_node_ip))))


def check_pacific_disk_number_by_disk_zone(pool, tmp_err_list, msg_head, lang):
    if pool.getMainStorageDiskType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD \
            or pool.getMainStorageDiskType() == DiskTypeEnum.SSD:
        return
    node_and_disk_num_dic = common. \
        get_pacific_node_and_disk_num_dic(pool, common.CACHE_DISK_TYPE)
    error_node_ip = []
    # 太平洋节点，每个节点缓存盘数量必须为4
    for node_ip, disk_num in node_and_disk_num_dic.items():
        if disk_num != 4:
            error_node_ip.append(node_ip)
    if error_node_ip:
        tmp_err_list.append(
            common.get_err_msg(lang,
                               "pool.cache.disk.num.out.of.specification",
                               (msg_head,
                                ",".join(error_node_ip))))