# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException


import common
import cli_util
# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_fan_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查内存状态
    :param env:
    :return:
    """
    ret_list = []
    ret_list_dict = {}
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["logger"] = LOGGER
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_fan(param_dict, None, err_info_list, ret_list_dict)
        [ret_list.extend(t_ret) for t_ret in ret_list_dict.values()]
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_fan(param_dict, cluster_dev_node, err_info_list, ret_list_dict):
    """
    检查系统风扇信息
    :param param_dict: 参数列表
    :param ibmc_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list_dict: 回文
    :return:
    """
    flag, ret_json = common.get_system_over_view_info(cluster_dev_node)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    if not flag:
        if check_fan_status(cluster_dev_node, ret_list_dict, err_info_list):
            return
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                cluster_node_ip,
            )
        )
        return
    show_ret = "{}\n{}".format("/SystemOverview", ret_json)
    tmp_ret = cli_util.get_format_header_ret(cluster_node_ip, show_ret)
    cli_util.update_ret_dict(ret_list_dict, cluster_node_ip, tmp_ret)
    sys_list = ret_json.get("Chassis", [])
    sys_id_list = []
    for sys_info in sys_list:
        cpu_summary_dict = sys_info.get("FanSummary", {})
        system_id = sys_info.get("Id", "")
        if not common.is_dict_obj(cpu_summary_dict):
            continue
        mem_status_dict = cpu_summary_dict.get("Status")
        if not common.is_dict_obj(mem_status_dict):
            continue
        heal_rool_up_value = mem_status_dict.get("HealthRollup")
        if heal_rool_up_value != "OK":
            sys_id_list.append(system_id)

    if sys_id_list:
        get_fan_detail_info(
            cluster_dev_node, ret_list_dict, err_info_list
        )

    check_fan_alarm(cluster_dev_node, err_info_list, ret_list_dict)


def check_fan_status(cluster_dev_node, ret_list_dict, err_info_list):
    """
    通过接口redfish/v1/Chassis/查询风扇的健康状态
    :param err_info_list: 错误信息列表
    :param cluster_dev_node: 节点
    :param ret_list_dict: 回文
    :return:
    """
    flag, ret_json, path = common.get_chassis_hardware_resource(cluster_dev_node, LOGGER, "Thermal")
    show_ret = "{}\n{}".format(path, ret_json)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    tmp_ret = cli_util.get_format_header_ret(cluster_node_ip, show_ret)
    cli_util.update_ret_dict(ret_list_dict, cluster_node_ip, tmp_ret)
    if not flag:
        return False
    ome_list_info = ret_json.get("Oem", {})
    huawei_list_info = ome_list_info.get("Huawei", {})
    fan_summary_dict = huawei_list_info.get("FanSummary", {})
    fan_status_dict = fan_summary_dict.get("Status", {})
    fan_health_status = fan_status_dict.get("HealthRollup", {})
    if str(fan_health_status).upper() != "OK":
        get_fan_detail_info(
            cluster_dev_node, ret_list_dict, err_info_list)
        check_fan_alarm(cluster_dev_node, err_info_list, ret_list_dict)
    return True


def get_fan_detail_info(
    cluster_dev_node, ret_list_dict, err_info_list
):
    """
    获取风扇详情
    :param cluster_dev_node: ibmc节点
    :param ret_list_dict: 原始信息列表
    :param err_info_list: 错误消息
    :return:
    """
    dev_ip = common.get_node_ip(cluster_dev_node)
    redfish_conn = common.get_redfish_conn(cluster_dev_node)
    cmd_url = "/Chassis"
    flag, ret_json = cli_util.execute_redfish_get(redfish_conn, cmd_url)
    tmp_ret = "{}\n{}".format(cmd_url, str(ret_json))
    cli_util.update_ret_dict(ret_list_dict, dev_ip, tmp_ret)
    if flag is not True:
        tmp_err_msg = common.get_err_msg(
            LANG, "hardware.status.check.failed", dev_ip)
        err_info_list.append(tmp_err_msg)
        return
    members = ret_json.get("Members", [])
    fan_urls = [member.values()[0] for member in members]
    LOGGER.logInfo("fan url:{}".format(fan_urls))
    them_url_list = []
    for fan_url in fan_urls:
        _, tmp_json = cli_util.direct_execute_redfish_get(
            redfish_conn, fan_url)
        tmp_ret = "\n{}\n{}".format(fan_url, str(tmp_json))
        cli_util.update_ret_dict(ret_list_dict, dev_ip, tmp_ret)
        them_url_list.extend(tmp_json.get("Thermal", {}).values())
    LOGGER.logInfo("them_url_list url:{}".format(them_url_list))
    if not them_url_list:
        return
    fan_info_list = []
    for them_url in them_url_list:
        _, ret_json = cli_util.direct_execute_redfish_get(
            redfish_conn, them_url)
        tmp_ret = "\n{}\n{}".format(them_url, str(ret_json))
        cli_util.update_ret_dict(ret_list_dict, dev_ip, tmp_ret)
        fan_info_list.extend(ret_json.get("Fans", []))
    LOGGER.logInfo("dev_ip:{},fan_info_list len:{}".format(
        dev_ip, len(fan_info_list)))
    if not fan_info_list:
        return
    tmp_err_detail_list = check_detail_info(fan_info_list)
    LOGGER.logInfo(
        "dev_ip:{},err_detail_list:{}".format(dev_ip, tmp_err_detail_list))
    if tmp_err_detail_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.fan.status.not.pass",
                (dev_ip, ",".join(list(set(tmp_err_detail_list)))),
            )
        )


def check_detail_info(fan_info_list):
    """
    检查详情信息
    :param fan_info_list:
    :return:
    """
    tmp_err_detail_list = []
    for fan_info in fan_info_list:
        status_dict = fan_info.get("Status", {})
        health = status_dict.get("Health", {})
        if health == "OK":
            continue

        status_dict = fan_info.get("Oem", {})
        health_dict = status_dict.values()[0] if status_dict.values() else {}
        fan_pos = health_dict.get("Position")
        tmp_err_detail_list.append(fan_pos)
    return tmp_err_detail_list


def check_fan_alarm(cluster_dev_node, err_info_list, ret_list_dict):
    """
    检查健康状态
    :param cluster_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list_dict: 回文
    :return:
    """
    dev_ip = common.get_node_ip(cluster_dev_node)
    flag, ret, res_list = common.get_alam_major_certical(cluster_dev_node)
    cli_util.update_ret_dict(ret_list_dict, dev_ip, ret)
    if flag is not True:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                dev_ip,
            )
        )
        return False
    tmp_err_list = []
    for line in ret.splitlines():
        # 0x040F0005或0x04000003或0x040F000F
        if any([
            "0x040F0005" in line,
            "0x04000003" in line,
            "0x040F000F" in line
        ]):
            tmp_err_list.append("\n{}".format(line))

    if tmp_err_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.fan.status.not.pass.fan.alarm",
                (dev_ip, "".join(tmp_err_list)),
            )
        )
