# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_mem_health_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查内存状态
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["ret_list"] = ret_list
        param_dict["logger"] = LOGGER
        param_dict["err_info_list"] = err_info_list
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_mem(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_mem(param_dict, cluster_dev_node, err_info_list, ret_list):
    """
    检查系统内存信息
    :param param_dict: 参数列表
    :param cluster_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list: 回文
    :return:
    """
    flag, ret_json = common.get_system_over_view_info(cluster_dev_node)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    if not flag:
        if check_mem_status(cluster_dev_node, ret_list, err_info_list):
            return
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                cluster_node_ip,
            )
        )
        return
    show_ret = "{}\n{}".format("/SystemOverview", ret_json)
    ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, show_ret))
    sys_list = ret_json.get("Systems", [])
    error_id_list = []
    for sys_info in sys_list:
        cpu_summary_dict = sys_info.get("MemorySummary", {})
        system_id = sys_info.get("Id", "")
        if not common.is_dict_obj(cpu_summary_dict):
            continue
        mem_status_dict = cpu_summary_dict.get("Status")
        if not common.is_dict_obj(mem_status_dict):
            continue
        heal_rool_up_value = mem_status_dict.get("HealthRollup")
        if str(heal_rool_up_value).upper() != "OK":
            error_id_list.append(system_id)

    if error_id_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.mem.health.status.not.pass",
                cluster_node_ip,
            )
        )


def check_mem_status(cluster_dev_node, ret_list, err_info_list):
    """
    :param cluster_dev_node:节点
    :param ret_list:回文列表
    :param err_info_list:错误信息列表
    :return:获取信息是否成功
    """
    result, status = common.get_hardware_health_status(cluster_dev_node, LOGGER, ret_list, "MemorySummary")
    if result and status != "OK":
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.mem.health.status.not.pass",
                common.get_node_ip(cluster_dev_node)))
    return result
