# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_primary_power_health_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查一次电源健康状态
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["ret_list"] = ret_list
        param_dict["logger"] = LOGGER
        param_dict["err_info_list"] = err_info_list
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_power(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_power(param_dict, cluster_dev_node, err_info_list, ret_list):
    """
    检查一次电源健康状态
    :param param_dict: 参数列表
    :param cluster_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list: 回文
    :return:
    """
    dev_ip = common.get_node_ip(cluster_dev_node)
    flag, ret, res_list = common.get_alam_major_certical(cluster_dev_node)
    ret_list.append(cli_util.get_format_header_ret(dev_ip, ret))
    if flag is not True:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                dev_ip,
            )
        )
        return False
    tmp_err_power_list = []
    for line in ret.splitlines():
        # 如果存在电源相关告警（0x0300000D/0x03000009）信息，则检查不通过
        if any([
            "0x0300000D" in line,
            "0x03000009" in line,
        ]):
            tmp_err_power_list.append("\n{}".format(line))

    if tmp_err_power_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.power.status.not.pass",
                (dev_ip, "".join(tmp_err_power_list)),
            )
        )
