# coding: UTF-8

import common

from com.huawei.ism.exception import IsmException
from check_pool_num import CheckPoolNumUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_storage_node_num"
# 集群最大节点数
MAX_NODE_NUM_IN_DEV = 256


def execute(rest):
    """
    检查扩容存储节点数
    :param env:
    :return:
    """
    ret_list = common.get_err_msg(LANG, "expansion.config.info")
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    tmp_warning_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 获取存储池
        storage_pools = dev_node.getStoragePools()
        if not storage_pools:
            return common.INSPECT_UNNORMAL, ret_list, common.get_err_msg(
                LANG, "query.result.abnormal")
        total_node_num = 0
        for storage_pool in storage_pools:
            for disk_pool in storage_pool.getDiskPools():
                msg_head = common.get_err_msg(LANG,
                                              "storage.pool.msg",
                                              (storage_pool.getName()))
                pool_util = CheckPoolNumUtil(disk_pool, msg_head, LANG, LOGGER, dev_node)
                total_node_num += len(pool_util.all_nodes)
                tmp_err_info, tmp_warning_info = pool_util.check_pool_node_num_info()
                tmp_err_list.extend(tmp_err_info)
                tmp_warning_list.extend(tmp_warning_info)
        # 集群总数检查
        if total_node_num > MAX_NODE_NUM_IN_DEV:
            err_info = common.get_err_msg(LANG,
                                          "hardware.storage.node.num.total",
                                          total_node_num)
            tmp_err_list.append(err_info)
        if tmp_err_list:
            tmp_err_list.extend(tmp_warning_list)
            return common.INSPECT_UNNORMAL, ret_list, "\n".join(tmp_err_list)
        if tmp_warning_list:
            return common.INSPECT_WARNING, ret_list, "\n".join(
                tmp_warning_list)
        return common.INSPECT_PASS, ret_list, ''

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            ret_list,
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
